/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigEntryColor;
import ftb.lib.api.config.ConfigEntryCustom;
import ftb.lib.api.config.ConfigEntryDouble;
import ftb.lib.api.config.ConfigEntryEnumExtended;
import ftb.lib.api.config.ConfigEntryInt;
import ftb.lib.api.config.ConfigEntryIntList;
import ftb.lib.api.config.ConfigEntryString;
import ftb.lib.api.config.ConfigEntryStringList;
import ftb.lib.api.config.ConfigGroup;
import latmod.lib.IntList;
import latmod.lib.LMColor;

public enum ConfigEntryType {
    CUSTOM(1),
    GROUP(2),
    BOOLEAN(3),
    INT(4),
    DOUBLE(5),
    STRING(6),
    ENUM(7),
    INT_ARRAY(8),
    STRING_ARRAY(9),
    COLOR(10);

    public final byte ID;
    private static final ConfigEntryType[] types;

    private ConfigEntryType(int i) {
        this.ID = (byte)i;
    }

    public ConfigEntry createNew(String id) {
        switch (this) {
            case CUSTOM: {
                return new ConfigEntryCustom(id);
            }
            case GROUP: {
                return new ConfigGroup(id);
            }
            case BOOLEAN: {
                return new ConfigEntryBool(id, false);
            }
            case INT: {
                return new ConfigEntryInt(id, 0);
            }
            case DOUBLE: {
                return new ConfigEntryDouble(id, 0.0);
            }
            case STRING: {
                return new ConfigEntryString(id, null);
            }
            case ENUM: {
                return new ConfigEntryEnumExtended(id);
            }
            case INT_ARRAY: {
                return new ConfigEntryIntList(id, (IntList)null);
            }
            case STRING_ARRAY: {
                return new ConfigEntryStringList(id, null);
            }
            case COLOR: {
                return new ConfigEntryColor(id, new LMColor.RGB());
            }
        }
        return null;
    }

    public static ConfigEntryType getFromID(byte id) {
        return types[id];
    }

    static {
        types = new ConfigEntryType[32];
        ConfigEntryType[] configEntryTypeArray = ConfigEntryType.values();
        int n = configEntryTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigEntryType t;
            ConfigEntryType.types[t.ID] = t = configEntryTypeArray[i];
        }
    }
}

