/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.IntList;
import latmod.lib.LMListUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ConfigEntryStringList
extends ConfigEntry {
    public final List<String> defValue;
    private List<String> value = new ArrayList<String>();

    public ConfigEntryStringList(String id, List<String> def) {
        super(id);
        this.defValue = new ArrayList<String>();
        if (def != null && !def.isEmpty()) {
            this.defValue.addAll(def);
            this.value.addAll(def);
        }
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.STRING_ARRAY;
    }

    @Override
    public int getColor() {
        return 16755273;
    }

    public void set(List<String> o) {
        this.value.clear();
        if (o != null && !o.isEmpty()) {
            this.value.addAll(o);
        }
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        this.value.clear();
        for (int i = 0; i < a.size(); ++i) {
            this.value.add(a.get(i).getAsString());
        }
        this.set(LMListUtils.clone(this.value));
    }

    @Override
    public final JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        for (String aValue : this.getAsStringList()) {
            a.add((JsonElement)new JsonPrimitive(aValue));
        }
        return a;
    }

    @Override
    public String getAsString() {
        return this.getAsStringList().toString();
    }

    @Override
    public boolean getAsBoolean() {
        return !this.getAsStringList().isEmpty();
    }

    @Override
    public IntList getAsIntList() {
        List<String> list = this.getAsStringList();
        IntList l = new IntList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            l.add(Integer.parseInt(this.value.get(i)));
        }
        return l;
    }

    @Override
    public List<String> getAsStringList() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        NBTTagList l;
        super.writeToNBT(tag, extended);
        List<String> list = this.getAsStringList();
        if (!list.isEmpty()) {
            l = new NBTTagList();
            for (String s : list) {
                l.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("V", (NBTBase)l);
        }
        if (extended && !this.defValue.isEmpty()) {
            l = new NBTTagList();
            for (String s : this.defValue) {
                l.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("D", (NBTBase)l);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        int i;
        ArrayList<String> l;
        super.readFromNBT(tag, extended);
        NBTTagList list = (NBTTagList)tag.func_74781_a("V");
        if (list != null) {
            l = new ArrayList<String>(list.func_74745_c());
            for (i = 0; i < list.func_74745_c(); ++i) {
                l.add(list.func_150307_f(i));
            }
            this.set(l);
        } else {
            this.set(null);
        }
        if (extended) {
            this.defValue.clear();
            list = (NBTTagList)tag.func_74781_a("D");
            if (list != null) {
                l = new ArrayList(list.func_74745_c());
                for (i = 0; i < list.func_74745_c(); ++i) {
                    this.defValue.add(list.func_150307_f(i));
                }
            }
        }
    }
}

