/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigEntryString
extends ConfigEntry {
    public String defValue;
    private String value;

    public ConfigEntryString(String id, String def) {
        super(id);
        this.set(def);
        this.defValue = def == null ? "" : def;
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.STRING;
    }

    @Override
    public int getColor() {
        return 16755273;
    }

    public void set(String o) {
        this.value = o == null ? "" : o;
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(o.getAsString());
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive(this.getAsString());
    }

    @Override
    public String getAsString() {
        return this.value;
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsString().equals("true");
    }

    @Override
    public int getAsInt() {
        return Integer.parseInt(this.getAsString());
    }

    @Override
    public double getAsDouble() {
        return Double.parseDouble(this.getAsString());
    }

    @Override
    public String getDefValueString() {
        return this.defValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        String s = this.getAsString();
        if (!s.isEmpty()) {
            tag.func_74778_a("V", s);
        }
        if (extended && !this.defValue.isEmpty()) {
            tag.func_74778_a("D", this.defValue);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(tag.func_74779_i("V"));
        if (extended) {
            this.defValue = tag.func_74779_i("D");
        }
    }
}

