/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.IntList;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigEntryIntList
extends ConfigEntry {
    public final IntList defValue;
    private IntList value;

    public ConfigEntryIntList(String id, IntList def) {
        super(id);
        this.defValue = def == null ? new IntList() : def.copy();
        this.value = this.defValue.copy();
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.INT_ARRAY;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    public ConfigEntryIntList(String id, int[] def) {
        this(id, IntList.asList(def));
    }

    public void set(IntList l) {
        this.value = l == null || l.isEmpty() ? new IntList() : l.copy();
    }

    @Override
    public void func_152753_a(JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        IntList l = new IntList(a.size());
        for (int i = 0; i < l.size(); ++i) {
            l.set(i, a.get(i).getAsInt());
        }
        this.set(l);
    }

    @Override
    public JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        this.value = this.getAsIntList();
        for (int i = 0; i < this.value.size(); ++i) {
            a.add((JsonElement)new JsonPrimitive((Number)this.value.get(i)));
        }
        return a;
    }

    @Override
    public String getAsString() {
        return this.getAsIntList().toString();
    }

    @Override
    public List<String> getAsStringList() {
        ArrayList<String> l = new ArrayList<String>();
        for (Integer i : this.getAsIntList()) {
            l.add(i.toString());
        }
        return l;
    }

    @Override
    public IntList getAsIntList() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        int[] ai = this.getAsIntList().toArray();
        if (ai.length > 0) {
            tag.func_74783_a("V", ai);
        }
        if (extended && !this.defValue.isEmpty()) {
            tag.func_74783_a("D", this.defValue.toArray());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(tag.func_74764_b("V") ? new IntList(tag.func_74759_k("V")) : null);
        if (extended) {
            this.defValue.clear();
            if (tag.func_74764_b("D")) {
                this.defValue.addAll(tag.func_74759_k("D"));
            }
        }
    }
}

