/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import latmod.lib.MathHelperLM;
import latmod.lib.annotations.INumberBoundsContainer;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigEntryInt
extends ConfigEntry
implements INumberBoundsContainer {
    public int defValue;
    private int value;
    private Integer minValue;
    private Integer maxValue;

    public ConfigEntryInt(String id, int def) {
        super(id);
        this.defValue = def;
        this.set(def);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.INT;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Integer.valueOf((int)min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Integer.valueOf((int)max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue.doubleValue();
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue.doubleValue();
    }

    public void set(int v) {
        this.value = MathHelperLM.clampInt(v, (int)this.getMin(), (int)this.getMax());
    }

    public void add(int i) {
        this.set(this.getAsInt() + i);
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(o == null || o.isJsonNull() ? this.defValue : o.getAsInt());
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getAsInt());
    }

    @Override
    public String getAsString() {
        return Integer.toString(this.getAsInt());
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsInt() != 0;
    }

    @Override
    public int getAsInt() {
        return this.value;
    }

    @Override
    public double getAsDouble() {
        return this.getAsInt();
    }

    @Override
    public String getDefValueString() {
        return Integer.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        tag.func_74768_a("V", this.getAsInt());
        if (extended) {
            tag.func_74768_a("D", this.defValue);
            double d = this.getMin();
            if (d != Double.NEGATIVE_INFINITY) {
                tag.func_74768_a("MN", (int)d);
            }
            if ((d = this.getMax()) != Double.POSITIVE_INFINITY) {
                tag.func_74768_a("MX", (int)d);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(tag.func_74762_e("V"));
        if (extended) {
            this.defValue = tag.func_74762_e("D");
            this.setBounds(tag.func_74764_b("MN") ? (double)tag.func_74762_e("MN") : Double.NEGATIVE_INFINITY, tag.func_74764_b("MX") ? (double)tag.func_74762_e("MX") : Double.POSITIVE_INFINITY);
        }
    }
}

