/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.IClickable;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public final class ConfigEntryEnumExtended
extends ConfigEntry
implements IClickable {
    private final List<String> values;
    private String value;
    private String defValue;

    public ConfigEntryEnumExtended(String id) {
        super(id);
        this.values = new ArrayList<String>();
    }

    public ConfigEntryEnumExtended(String id, List<String> vals, String def) {
        super(id);
        this.values = vals;
        this.value = this.defValue = def;
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.ENUM;
    }

    @Override
    public int getColor() {
        return 38143;
    }

    public void set(String s) {
        this.value = s;
    }

    public int getIndex() {
        return this.values.indexOf(this.getAsString());
    }

    @Override
    public void func_152753_a(JsonElement o) {
        this.set(o.getAsString());
    }

    @Override
    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getAsString());
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        tag.func_74778_a("V", this.getAsString());
        if (extended) {
            tag.func_74778_a("D", this.defValue);
            if (!this.values.isEmpty()) {
                NBTTagList list = new NBTTagList();
                for (String s : this.values) {
                    list.func_74742_a((NBTBase)new NBTTagString(s));
                }
                tag.func_74782_a("VL", (NBTBase)list);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(tag.func_74779_i("V"));
        if (extended) {
            this.defValue = tag.func_74779_i("D");
            this.values.clear();
            if (tag.func_74764_b("VL")) {
                NBTTagList list = (NBTTagList)tag.func_74781_a("VL");
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.values.add(list.func_150307_f(i));
                }
            }
        }
    }

    @Override
    public void onClicked(boolean leftClick) {
        int i = this.getIndex() + (leftClick ? 1 : -1);
        if (i < 0) {
            i = this.values.size() - 1;
        }
        if (i >= this.values.size()) {
            i = 0;
        }
        this.set(this.values.get(i));
    }

    @Override
    public String getAsString() {
        return this.value;
    }

    @Override
    public boolean getAsBoolean() {
        return this.getAsString() != null;
    }

    @Override
    public int getAsInt() {
        return this.getIndex();
    }

    @Override
    public String getDefValueString() {
        return this.defValue;
    }
}

