/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.IClickable;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import java.util.LinkedHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ConfigEntryEnum<E extends Enum<E>>
extends ConfigEntry
implements IClickable {
    private final LinkedHashMap<String, E> enumMap = new LinkedHashMap();
    private E value;
    public final E defValue;

    public ConfigEntryEnum(String id, E[] val, E def, boolean addNull) {
        super(id);
        for (E e : val) {
            this.enumMap.put(ConfigEntryEnum.getName(e), e);
        }
        if (addNull) {
            this.enumMap.put("-", null);
        }
        this.set(def);
        this.defValue = def;
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.ENUM;
    }

    @Override
    public int getColor() {
        return 38143;
    }

    public void set(Object o) {
        this.value = (Enum)o;
    }

    public E get() {
        return this.value;
    }

    public static String getName(Enum<?> e) {
        return e == null ? "-" : e.name().toLowerCase();
    }

    private E fromString(String s) {
        return (E)((Enum)this.enumMap.get(s.toLowerCase()));
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(this.fromString(o.getAsString()));
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive(ConfigEntryEnum.getName(this.get()));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        tag.func_74778_a("V", ConfigEntryEnum.getName(this.get()));
        if (extended) {
            tag.func_74778_a("D", ConfigEntryEnum.getName(this.defValue));
            NBTTagList list = new NBTTagList();
            for (String s : this.enumMap.keySet()) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("VL", (NBTBase)list);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(this.fromString(tag.func_74779_i("V")));
    }

    @Override
    public void onClicked(boolean leftClick) {
        if (leftClick) {
            this.set(this.getFromIndex((this.getIndex() + 1) % this.enumMap.size()));
        } else {
            this.set(this.getFromIndex(this.getIndex() - 1 & this.enumMap.size() - 1));
        }
    }

    @Override
    public String getAsString() {
        return ConfigEntryEnum.getName(this.get());
    }

    @Override
    public boolean getAsBoolean() {
        return this.get() != null;
    }

    private E getFromIndex(int index) {
        if (index < 0 || index >= this.enumMap.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx0 = 0;
        for (Enum e : this.enumMap.values()) {
            if (index == idx0) {
                return (E)e;
            }
            ++idx0;
        }
        return null;
    }

    private int getIndex() {
        int idx0 = 0;
        E e0 = this.get();
        for (Enum e : this.enumMap.values()) {
            if (e == e0) {
                return idx0;
            }
            ++idx0;
        }
        return -1;
    }

    private int getDefaultIndex() {
        int idx0 = 0;
        for (Enum e : this.enumMap.values()) {
            if (e == this.defValue) {
                return idx0;
            }
            ++idx0;
        }
        return -1;
    }

    @Override
    public int getAsInt() {
        return this.enumMap.size();
    }

    @Override
    public String getDefValueString() {
        return ConfigEntryEnum.getName(this.defValue);
    }
}

