/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryType;
import latmod.lib.LMStringUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.annotations.INumberBoundsContainer;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigEntryDouble
extends ConfigEntry
implements INumberBoundsContainer {
    public double defValue;
    private double value;
    private Double minValue;
    private Double maxValue;

    public ConfigEntryDouble(String id, double d) {
        super(id);
        this.defValue = d;
        this.set(d);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.DOUBLE;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Double.valueOf(min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Double.valueOf(max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue;
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue;
    }

    public void set(double v) {
        this.value = MathHelperLM.clamp(v, this.getMin(), this.getMax());
    }

    public void add(double v) {
        this.set(this.getAsDouble() + v);
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(o.getAsDouble());
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getAsDouble());
    }

    @Override
    public String getAsString() {
        return Double.toString(this.getAsDouble());
    }

    @Override
    public int getAsInt() {
        return (int)this.getAsDouble();
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public String getDefValueString() {
        return Double.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return LMStringUtils.formatDouble(d);
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        double d = this.getAsDouble();
        if (d != 0.0) {
            tag.func_74780_a("V", d);
        }
        if (extended) {
            if (this.defValue != 0.0) {
                tag.func_74780_a("D", this.defValue);
            }
            if ((d = this.getMin()) != Double.NEGATIVE_INFINITY) {
                tag.func_74780_a("MN", d);
            }
            if ((d = this.getMax()) != Double.POSITIVE_INFINITY) {
                tag.func_74780_a("MX", d);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        this.set(tag.func_74769_h("V"));
        if (extended) {
            this.defValue = tag.func_74769_h("D");
            this.setBounds(tag.func_74764_b("MN") ? tag.func_74769_h("MN") : Double.NEGATIVE_INFINITY, tag.func_74764_b("MX") ? tag.func_74769_h("MX") : Double.POSITIVE_INFINITY);
        }
    }
}

