/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import ftb.lib.api.config.ConfigEntryType;
import ftb.lib.api.config.ConfigGroup;
import java.util.Collections;
import java.util.List;
import latmod.lib.Bits;
import latmod.lib.IntList;
import latmod.lib.annotations.IFlagContainer;
import latmod.lib.annotations.IInfoContainer;
import latmod.lib.util.FinalIDObject;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IJsonSerializable;

public abstract class ConfigEntry
extends FinalIDObject
implements IInfoContainer,
IFlagContainer,
IJsonSerializable {
    public ConfigGroup parentGroup;
    private String[] info;
    protected byte flags = 0;

    ConfigEntry(String id) {
        super(id);
    }

    public abstract ConfigEntryType getConfigType();

    public abstract void func_152753_a(JsonElement var1);

    public abstract JsonElement func_151003_a();

    public int getColor() {
        return 0x999999;
    }

    public String getFullID() {
        if (this.parentGroup == null) {
            return this.getID();
        }
        return this.parentGroup.getFullID() + '.' + this.getID();
    }

    public String getDefValueString() {
        return null;
    }

    public String getMinValueString() {
        return null;
    }

    public String getMaxValueString() {
        return null;
    }

    public ConfigEntry copy() {
        ConfigEntry e = this.getConfigType().createNew(this.getID());
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag, true);
        e.readFromNBT(tag, true);
        return e;
    }

    @Override
    public final String toString() {
        return this.getAsString();
    }

    public abstract String getAsString();

    public boolean getAsBoolean() {
        return false;
    }

    public int getAsInt() {
        return 0;
    }

    public double getAsDouble() {
        return 0.0;
    }

    public IntList getAsIntList() {
        return new IntList(new int[]{this.getAsInt()});
    }

    public List<String> getAsStringList() {
        return Collections.singletonList(this.getAsString());
    }

    public ConfigGroup getAsGroup() {
        return null;
    }

    @Override
    public final void setFlag(byte flag, boolean b) {
        this.flags = Bits.setBit(this.flags, flag, b);
    }

    @Override
    public final boolean getFlag(byte flag) {
        return Bits.getBit(this.flags, flag);
    }

    @Override
    public final void setInfo(String[] s) {
        this.info = s != null && s.length > 0 ? s : null;
    }

    @Override
    public final String[] getInfo() {
        return this.info;
    }

    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        if (extended) {
            if (this.flags != 0) {
                tag.func_74774_a("F", this.flags);
            }
            if (this.info != null && this.info.length > 0) {
                NBTTagList list = new NBTTagList();
                for (int i = 0; i < this.info.length; ++i) {
                    list.func_74742_a((NBTBase)new NBTTagString(this.info[i]));
                }
                tag.func_74782_a("I", (NBTBase)list);
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        if (extended) {
            this.flags = tag.func_74771_c("F");
            this.info = null;
            if (tag.func_74764_b("I")) {
                NBTTagList list = tag.func_150295_c("I", 8);
                this.info = new String[list.func_74745_c()];
                for (int i = 0; i < this.info.length; ++i) {
                    this.info[i] = list.func_150307_f(i);
                }
            }
        }
    }
}

