/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.mod.FTBLibMod;
import java.util.List;
import java.util.Random;
import latmod.lib.MathHelperLM;
import latmod.lib.util.VecLM;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MathHelperMC {
    public static int get2DRotation(EntityLivingBase el) {
        int i = MathHelperLM.getRotations(el.field_70177_z, 4);
        if (i == 0) {
            return 2;
        }
        if (i == 1) {
            return 4;
        }
        if (i == 2) {
            return 3;
        }
        if (i == 3) {
            return 5;
        }
        return -1;
    }

    public static int get3DRotation(World w, int x, int y, int z, EntityLivingBase el) {
        return BlockPistonBase.func_150071_a((World)w, (int)x, (int)y, (int)z, (EntityLivingBase)el);
    }

    public static VecLM randomAABB(Random r, AxisAlignedBB bb) {
        double x = MathHelperLM.randomDouble(r, bb.field_72340_a, bb.field_72336_d);
        double y = MathHelperLM.randomDouble(r, bb.field_72338_b, bb.field_72337_e);
        double z = MathHelperLM.randomDouble(r, bb.field_72339_c, bb.field_72334_f);
        return new VecLM(x, y, z);
    }

    public static Vec3 getEyePosition(EntityPlayer ep) {
        double y = 0.0;
        if (!ep.field_70170_p.field_72995_K) {
            y = ep.func_70047_e();
        }
        return Vec3.func_72443_a((double)ep.field_70165_t, (double)(ep.field_70163_u + y), (double)ep.field_70161_v);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer ep, double d) {
        if (ep == null) {
            return null;
        }
        Vec3 pos = MathHelperMC.getEyePosition(ep);
        Vec3 look = ep.func_70040_Z();
        Vec3 vec = pos.func_72441_c(look.field_72450_a * d, look.field_72448_b * d, look.field_72449_c * d);
        MovingObjectPosition mop = ep.field_70170_p.func_147447_a(pos, vec, false, true, false);
        if (mop != null && mop.field_72307_f == null) {
            mop.field_72307_f = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        return mop;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer ep) {
        return MathHelperMC.rayTrace(ep, FTBLibMod.proxy.getReachDist(ep));
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, AxisAlignedBB[] boxes) {
        if (boxes == null || boxes.length <= 0) {
            return null;
        }
        MovingObjectPosition current = null;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boxes.length; ++i) {
            MovingObjectPosition mop;
            if (boxes[i] == null || (mop = MathHelperMC.collisionRayTrace(w, x, y, z, start, end, boxes[i])) == null) continue;
            double d1 = mop.field_72307_f.func_72436_e(start);
            if (current != null && !(d1 < dist)) continue;
            current = mop;
            current.subHit = i;
            dist = d1;
        }
        return current;
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, List<AxisAlignedBB> boxes) {
        AxisAlignedBB[] boxesa = new AxisAlignedBB[boxes.size()];
        for (int i = 0; i < boxesa.length; ++i) {
            boxesa[i] = boxes.get(i).func_72321_a(0.0, 0.0, 0.0);
        }
        return MathHelperMC.collisionRayTrace(w, x, y, z, start, end, boxesa);
    }

    public static MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 start, Vec3 end, AxisAlignedBB aabb) {
        Vec3 pos = start.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 rot = end.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 xmin = pos.func_72429_b(rot, aabb.field_72340_a);
        Vec3 xmax = pos.func_72429_b(rot, aabb.field_72336_d);
        Vec3 ymin = pos.func_72435_c(rot, aabb.field_72338_b);
        Vec3 ymax = pos.func_72435_c(rot, aabb.field_72337_e);
        Vec3 zmin = pos.func_72434_d(rot, aabb.field_72339_c);
        Vec3 zmax = pos.func_72434_d(rot, aabb.field_72334_f);
        if (!MathHelperMC.isVecInsideYZBounds(xmin, aabb)) {
            xmin = null;
        }
        if (!MathHelperMC.isVecInsideYZBounds(xmax, aabb)) {
            xmax = null;
        }
        if (!MathHelperMC.isVecInsideXZBounds(ymin, aabb)) {
            ymin = null;
        }
        if (!MathHelperMC.isVecInsideXZBounds(ymax, aabb)) {
            ymax = null;
        }
        if (!MathHelperMC.isVecInsideXYBounds(zmin, aabb)) {
            zmin = null;
        }
        if (!MathHelperMC.isVecInsideXYBounds(zmax, aabb)) {
            zmax = null;
        }
        Vec3 v = null;
        if (xmin != null && (v == null || pos.func_72436_e(xmin) < pos.func_72436_e(v))) {
            v = xmin;
        }
        if (xmax != null && (v == null || pos.func_72436_e(xmax) < pos.func_72436_e(v))) {
            v = xmax;
        }
        if (ymin != null && (v == null || pos.func_72436_e(ymin) < pos.func_72436_e(v))) {
            v = ymin;
        }
        if (ymax != null && (v == null || pos.func_72436_e(ymax) < pos.func_72436_e(v))) {
            v = ymax;
        }
        if (zmin != null && (v == null || pos.func_72436_e(zmin) < pos.func_72436_e(v))) {
            v = zmin;
        }
        if (zmax != null && (v == null || pos.func_72436_e(zmax) < pos.func_72436_e(v))) {
            v = zmax;
        }
        if (v == null) {
            return null;
        }
        int side = -1;
        if (v == xmin) {
            side = 5;
        }
        if (v == xmax) {
            side = 4;
        }
        if (v == ymin) {
            side = 0;
        }
        if (v == ymax) {
            side = 1;
        }
        if (v == zmin) {
            side = 2;
        }
        if (v == zmax) {
            side = 3;
        }
        return new MovingObjectPosition(x, y, z, side, v.func_72441_c((double)x, (double)y, (double)z), true);
    }

    private static boolean isVecInsideYZBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(Vec3 v, AxisAlignedBB aabb) {
        return v == null ? false : v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e;
    }

    public static MovingObjectPosition getMOPFrom(int x, int y, int z, int s, float hitX, float hitY, float hitZ) {
        return new MovingObjectPosition(x, y, z, s, Vec3.func_72443_a((double)((float)x + hitX), (double)((float)y + hitY), (double)((float)z + hitZ)), true);
    }

    public static AxisAlignedBB getBox(double cx, double y0, double cz, double w, double y1, double d) {
        return AxisAlignedBB.func_72330_a((double)(cx - w / 2.0), (double)y0, (double)(cz - d / 2.0), (double)(cx + w / 2.0), (double)y1, (double)(cz + d / 2.0));
    }

    public static AxisAlignedBB centerBox(double x, double y, double z, double w, double h, double d) {
        return MathHelperMC.getBox(x, y - h / 2.0, z, w, y + h / 2.0, d);
    }

    public static AxisAlignedBB rotate90BoxV(AxisAlignedBB bb, int dir) {
        double x1 = bb.field_72340_a;
        double y1 = bb.field_72338_b;
        double z1 = bb.field_72339_c;
        double x2 = bb.field_72336_d;
        double y2 = bb.field_72337_e;
        double z2 = bb.field_72334_f;
        if (dir < 0 || dir >= 6 || dir == 2 || dir == 3) {
            return AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
        return AxisAlignedBB.func_72330_a((double)z1, (double)y1, (double)x1, (double)z2, (double)y2, (double)x2);
    }
}

