/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.mod.FTBLibMod;
import java.io.File;
import java.io.FileInputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import latmod.lib.LMListUtils;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LMNBTUtils {
    public static String[] getMapKeys(NBTTagCompound tag) {
        if (tag == null || tag.func_82582_d()) {
            return new String[0];
        }
        return LMListUtils.toStringArray(tag.func_150296_c());
    }

    public static Map<String, NBTBase> toMap(NBTTagCompound tag) {
        HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
        for (Object s : tag.func_150296_c()) {
            map.put(s.toString(), tag.func_74781_a(s.toString()));
        }
        return map;
    }

    public static Set<Map.Entry<String, NBTBase>> entrySet(NBTTagCompound tag) {
        HashSet<Map.Entry<String, NBTBase>> l = new HashSet<Map.Entry<String, NBTBase>>();
        if (tag == null || tag.func_82582_d()) {
            return l;
        }
        for (Object s : tag.func_150296_c()) {
            l.add(new AbstractMap.SimpleEntry<String, NBTBase>(s.toString(), tag.func_74781_a(s.toString())));
        }
        return l;
    }

    public static <E extends NBTBase> Map<String, E> toMapWithType(NBTTagCompound tag) {
        HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
        if (tag == null || tag.func_82582_d()) {
            return map;
        }
        for (Object s : tag.func_150296_c()) {
            map.put(s.toString(), tag.func_74781_a(s.toString()));
        }
        return map;
    }

    public static Exception writeMap(File f, NBTTagCompound tag) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)f);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public static NBTTagCompound readMap(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            return CompressedStreamTools.func_74797_a((File)f);
        }
        catch (Exception e) {
            e.printStackTrace();
            FTBLibMod.logger.info("Possibly corrupted / old file. Trying the old method");
            try {
                FileInputStream is = new FileInputStream(f);
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                return CompressedStreamTools.func_152457_a((byte[])b, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static boolean areTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 != null && tag2 == null) {
            return false;
        }
        if (tag1 == null && tag2 != null) {
            return false;
        }
        return tag1.equals((Object)tag2);
    }

    public static void toStringList(List<String> l, NBTTagList tag) {
        l.clear();
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            l.add(tag.func_150307_f(i));
        }
    }

    public static List<String> toStringList(NBTTagList tag) {
        ArrayList<String> l = new ArrayList<String>();
        LMNBTUtils.toStringList(l, tag);
        return l;
    }

    public static NBTTagList fromStringList(List<String> l) {
        NBTTagList tag = new NBTTagList();
        for (int i = 0; i < l.size(); ++i) {
            tag.func_74742_a((NBTBase)new NBTTagString(l.get(i)));
        }
        return tag;
    }

    public static NBTTagCompound readTag(ByteIOStream data) {
        try {
            byte[] abyte = data.readByteArray(ByteCount.INT);
            if (abyte == null) {
                return null;
            }
            if (abyte.length == 0) {
                return new NBTTagCompound();
            }
            return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeTag(ByteIOStream data, NBTTagCompound tag) {
        try {
            byte[] abyte = tag == null ? null : (tag.func_82582_d() ? new byte[]{} : CompressedStreamTools.func_74798_a((NBTTagCompound)tag));
            data.writeByteArray(abyte, ByteCount.INT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

