/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyPylon
extends TileObjectSync
implements IEnergyHandler,
IExtendedRFStorage,
IDEPeripheral {
    public boolean active = false;
    public boolean lastTickActive = false;
    public boolean isReceivingEnergy = false;
    public boolean isReceivedEnergyLastTick = false;
    public float modelRotation = 0.0f;
    public float modelScale = 0.0f;
    private List<MultiblockHelper.TileLocation> coreLocations = new ArrayList<MultiblockHelper.TileLocation>();
    private int selectedCore = 0;
    private byte particleRate = 0;
    private byte lastTickParticleRate = 0;
    private int lastCheckCompOverride = 0;
    private int tick = 0;

    public void func_145845_h() {
        int comparatorOut;
        if (this.field_145850_b.field_72995_K) {
            if (this.active) {
                this.modelRotation = (float)((double)this.modelRotation + 1.5);
                this.modelScale += this.isReceivingEnergy ? 0.01f : -0.01f;
                if (this.modelScale < 0.0f) {
                    this.modelScale = this.isReceivingEnergy ? 0.0f : 10000.0f;
                }
                this.spawnParticles();
            } else {
                this.modelScale = 0.5f;
            }
            return;
        }
        ++this.tick;
        if (this.tick % 20 == 0 && (comparatorOut = (int)(this.getEnergyStored() / this.getMaxEnergyStored() * 15.0)) != this.lastCheckCompOverride) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
            this.lastCheckCompOverride = comparatorOut;
        }
        if (this.active && !this.isReceivingEnergy) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
                if (!(tile instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)tile;
                int energyToReceive = this.extractEnergy(side, Integer.MAX_VALUE, true);
                int energyReceived = receiver.receiveEnergy(side.getOpposite(), energyToReceive, false);
                this.extractEnergy(side, energyReceived, false);
            }
        }
        this.detectAndSendChanges();
        if (this.particleRate > 0) {
            this.particleRate = (byte)(this.particleRate - 1);
        }
    }

    public void onActivated() {
        if (!this.active) {
            this.active = this.isValidStructure();
        }
        this.findCores();
    }

    private TileEnergyStorageCore getMaster() {
        TileEntity tile;
        MultiblockHelper.TileLocation location;
        if (this.coreLocations.isEmpty()) {
            return null;
        }
        if (this.selectedCore >= this.coreLocations.size()) {
            this.selectedCore = this.coreLocations.size() - 1;
        }
        if ((location = this.coreLocations.get(this.selectedCore)) != null && (tile = location.getTileEntity(this.field_145850_b)) instanceof TileEnergyStorageCore) {
            TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
            return core;
        }
        return null;
    }

    private void findCores() {
        int yMod = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? 15 : -15;
        int range = 15;
        ArrayList<MultiblockHelper.TileLocation> locations = new ArrayList<MultiblockHelper.TileLocation>();
        for (int x = this.field_145851_c - range; x <= this.field_145851_c + range; ++x) {
            for (int y = this.field_145848_d + yMod - range; y <= this.field_145848_d + yMod + range; ++y) {
                for (int z = this.field_145849_e - range; z <= this.field_145849_e + range; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.energyStorageCore) continue;
                    locations.add(new MultiblockHelper.TileLocation(x, y, z));
                }
            }
        }
        if (locations != this.coreLocations) {
            this.coreLocations.clear();
            this.coreLocations.addAll(locations);
            this.selectedCore = this.selectedCore >= this.coreLocations.size() ? 0 : this.selectedCore;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void nextCore() {
        this.findCores();
        ++this.selectedCore;
        if (this.selectedCore >= this.coreLocations.size()) {
            this.selectedCore = 0;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        float disMod;
        Random rand = this.field_145850_b.field_73012_v;
        TileEnergyStorageCore core = this.getMaster();
        if (core == null || !core.isOnline()) {
            return;
        }
        int x = core.field_145851_c;
        int y = core.field_145848_d;
        int z = core.field_145849_e;
        int cYCoord = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.field_145848_d + 1 : this.field_145848_d - 1;
        switch (core.getTier()) {
            case 0: {
                float f = 0.5f;
                break;
            }
            case 1: 
            case 2: {
                float f = 1.0f;
                break;
            }
            case 3: 
            case 4: {
                float f = 2.0f;
                break;
            }
            case 5: {
                float f = 3.0f;
                break;
            }
            default: {
                float f = disMod = 4.0f;
            }
        }
        if (this.particleRate > 20) {
            this.particleRate = (byte)20;
        }
        double sourceX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
        double sourceY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
        double sourceZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
        double targetX = (double)this.field_145851_c + 0.5;
        double targetY = (double)cYCoord + 0.5;
        double targetZ = (double)this.field_145849_e + 0.5;
        if (rand.nextFloat() < 0.05f) {
            Particles.EnergyTransferParticle passiveParticle = this.isReceivingEnergy ? new Particles.EnergyTransferParticle(this.field_145850_b, targetX, targetY, targetZ, sourceX, sourceY, sourceZ, true) : new Particles.EnergyTransferParticle(this.field_145850_b, sourceX, sourceY, sourceZ, targetX, targetY, targetZ, true);
            ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
        }
        if (this.particleRate > 0 && (this.particleRate > 10 || rand.nextInt(Math.max(1, 10 - this.particleRate)) == 0)) {
            int iterations = this.particleRate > 10 ? this.particleRate / 10 : 1;
            for (int i = 0; i <= iterations; ++i) {
                sourceX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                sourceY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                sourceZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                Particles.EnergyTransferParticle passiveParticle = this.isReceivingEnergy ? new Particles.EnergyTransferParticle(this.field_145850_b, targetX, targetY, targetZ, sourceX, sourceY, sourceZ, false) : new Particles.EnergyTransferParticle(this.field_145850_b, sourceX, sourceY, sourceZ, targetX, targetY, targetZ, false);
                ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
            }
        }
    }

    private boolean isValidStructure() {
        boolean hasGlassBelow;
        boolean hasGlassAbove = this.isGlass(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        return hasGlassAbove != (hasGlassBelow = this.isGlass(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
    }

    private boolean isGlass(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.invisibleMultiblock && this.field_145850_b.func_72805_g(x, y, z) == 2;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.active = compound.func_74767_n("Active");
        this.isReceivingEnergy = compound.func_74767_n("Input");
        int i = compound.func_74762_e("Cores");
        ArrayList<MultiblockHelper.TileLocation> list = new ArrayList<MultiblockHelper.TileLocation>();
        for (int j = 0; j < i; ++j) {
            MultiblockHelper.TileLocation l = new MultiblockHelper.TileLocation();
            l.readFromNBT(compound, "Core" + j);
            list.add(l);
        }
        this.coreLocations = list;
        this.selectedCore = compound.func_74762_e("SelectedCore");
        this.particleRate = compound.func_74771_c("ParticleRate");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Input", this.isReceivingEnergy);
        int i = this.coreLocations.size();
        compound.func_74768_a("Cores", i);
        for (int j = 0; j < i; ++j) {
            this.coreLocations.get(j).writeToNBT(compound, "Core" + j);
        }
        compound.func_74768_a("SelectedCore", this.selectedCore);
        compound.func_74774_a("ParticleRate", this.particleRate);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int received;
        if (this.getMaster() == null) {
            return 0;
        }
        int n = received = this.isReceivingEnergy ? this.getMaster().receiveEnergy(maxReceive, simulate) : 0;
        if (!simulate && received > 0) {
            this.particleRate = (byte)Math.min(20, received < 500 ? 1 : received / 500);
        }
        return received;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int extracted;
        if (this.getMaster() == null || !this.getMaster().isOnline()) {
            return 0;
        }
        int n = extracted = this.isReceivingEnergy ? 0 : this.getMaster().extractEnergy(maxExtract, simulate);
        if (!simulate && extracted > 0) {
            this.particleRate = (byte)Math.min(20, extracted < 500 ? 1 : extracted / 500);
        }
        return extracted;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.getMaster() == null) {
            return 0;
        }
        return (int)Math.min(Integer.MAX_VALUE, this.getMaster().getEnergyStored());
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getMaster() == null) {
            return 0;
        }
        return (int)Math.min(Integer.MAX_VALUE, this.getMaster().getMaxEnergyStored());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private void detectAndSendChanges() {
        if (this.lastTickActive != this.active) {
            this.lastTickActive = (Boolean)this.sendObjectToClient((byte)6, 0, this.active, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 256.0));
        }
        if (this.isReceivedEnergyLastTick != this.isReceivingEnergy) {
            this.isReceivedEnergyLastTick = (Boolean)this.sendObjectToClient((byte)6, 1, this.isReceivingEnergy, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 256.0));
        }
        if (this.lastTickParticleRate != this.particleRate) {
            this.lastTickParticleRate = (Byte)this.sendObjectToClient((byte)0, 2, this.particleRate);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        switch (index) {
            case 0: {
                this.active = (Boolean)object;
                break;
            }
            case 1: {
                this.isReceivingEnergy = (Boolean)object;
                break;
            }
            case 2: {
                this.particleRate = (Byte)object;
            }
        }
    }

    @Override
    public double getEnergyStored() {
        return this.getMaster() != null ? (double)this.getMaster().getEnergyStored() : 0.0;
    }

    @Override
    public double getMaxEnergyStored() {
        return this.getMaster() != null ? (double)this.getMaster().getMaxEnergyStored() : 0.0;
    }

    @Override
    public long getExtendedStorage() {
        return this.getMaster() != null ? this.getMaster().getEnergyStored() : 0L;
    }

    @Override
    public long getExtendedCapacity() {
        return this.getMaster() != null ? this.getMaster().getMaxEnergyStored() : 0L;
    }

    @Override
    public String getName() {
        return "draconic_rf_storage";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getEnergyStored", "getMaxEnergyStored"};
    }

    @Override
    public Object[] callMethod(String method, Object ... args) {
        if (method.equals("getEnergyStored")) {
            return new Object[]{this.getExtendedStorage()};
        }
        if (method.equals("getMaxEnergyStored")) {
            return new Object[]{this.getExtendedCapacity()};
        }
        return new Object[0];
    }
}

