/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.client.GuiButtonSort;
import net.blay09.mods.cookingforblockheads.container.ContainerRecipeBook;
import net.blay09.mods.cookingforblockheads.container.slot.SlotRecipe;
import net.blay09.mods.cookingforblockheads.network.MessageSort;
import net.blay09.mods.cookingforblockheads.network.MessageSwitchRecipe;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import yalter.mousetweaks.api.IMTModGuiContainer;

@Optional.Interface(modid="MouseTweaks", iface="yalter.mousetweaks.api.IMTModGuiContainer")
public class GuiRecipeBook
extends GuiContainer
implements IMTModGuiContainer {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final ContainerRecipeBook container;
    private boolean registered;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private GuiButton btnNextRecipe;
    private GuiButton btnPrevRecipe;
    private GuiTextField searchBar;
    private GuiButtonSort[] sortButtons;
    private GuiButtonSort btnSortName;
    private GuiButtonSort btnSortHunger;
    private GuiButtonSort btnSortSaturation;
    @Nullable
    private GuiButtonSort btnSortSoL;
    private final String[] noIngredients;
    private final String[] noSelection;
    private Slot hoverSlot;
    private boolean isSoLLoaded = false;

    public GuiRecipeBook(ContainerRecipeBook container) {
        super((Container)container);
        this.container = container;
        this.noIngredients = StatCollector.func_74838_a((String)"cookingforblockheads:no_ingredients").split("\\\\n");
        this.noSelection = StatCollector.func_74838_a((String)"cookingforblockheads:no_selection").split("\\\\n");
        if (Loader.isModLoaded((String)"SpiceOfLife")) {
            this.isSoLLoaded = true;
        }
    }

    public void func_73866_w_() {
        this.field_147000_g = 174;
        super.func_73866_w_();
        this.btnPrevRecipe = new GuiButton(0, this.field_146294_l / 2 - 79, this.field_146295_m / 2 - 51, 13, 20, "<");
        this.btnPrevRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnPrevRecipe);
        this.btnNextRecipe = new GuiButton(1, this.field_146294_l / 2 - 9, this.field_146295_m / 2 - 51, 13, 20, ">");
        this.btnNextRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnNextRecipe);
        this.btnSortName = new GuiButtonSort(2, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 80, 196, "cookingforblockheads:sort_by_name.tooltip");
        this.field_146292_n.add(this.btnSortName);
        this.btnSortHunger = new GuiButtonSort(3, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 60, 216, "cookingforblockheads:sort_by_hunger.tooltip");
        this.field_146292_n.add(this.btnSortHunger);
        this.btnSortSaturation = new GuiButtonSort(4, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 40, 236, "cookingforblockheads:sort_by_saturation.tooltip");
        this.field_146292_n.add(this.btnSortSaturation);
        if (this.isSoLLoaded) {
            this.btnSortSoL = new GuiButtonSort(5, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 20, 176, 60, "cookingforblockheads:sort_by_sol.tooltip");
            this.field_146292_n.add(this.btnSortSoL);
        }
        this.sortButtons = this.isSoLLoaded ? new GuiButtonSort[]{this.btnSortName, this.btnSortHunger, this.btnSortSaturation, this.btnSortSoL} : new GuiButtonSort[]{this.btnSortName, this.btnSortHunger, this.btnSortSaturation};
        this.searchBar = new GuiTextField(this.field_146289_q, this.field_147003_i + this.field_146999_f - 85, this.field_147009_r - 10, 70, 10);
        this.searchBar.func_146189_e(false);
        if (!this.registered) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
        this.recalculateScrollBar();
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.registered) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button == this.btnPrevRecipe) {
            this.container.prevRecipe();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSwitchRecipe(-1));
        } else if (button == this.btnNextRecipe) {
            this.container.nextRecipe();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSwitchRecipe(1));
        } else if (button == this.btnSortName) {
            this.container.sortingChanged();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSort(0));
        } else if (button == this.btnSortHunger) {
            this.container.sortingChanged();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSort(1));
        } else if (button == this.btnSortSaturation) {
            this.container.sortingChanged();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSort(2));
        } else if (button == this.btnSortSoL) {
            this.container.sortingChanged();
            NetworkHandler.instance.sendToServer((IMessage)new MessageSort(3));
        }
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getAvailableRecipeCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getAvailableRecipeCount() / 3.0f) - 4);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            return;
        }
        this.setCurrentOffset(delta > 0 ? this.currentOffset - 1 : this.currentOffset + 1);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    protected void func_73869_a(char c, int keyCode) {
        if (!this.searchBar.func_146201_a(c, keyCode)) {
            super.func_73869_a(c, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1 && mouseX >= this.searchBar.field_146209_f && mouseX < this.searchBar.field_146209_f + this.searchBar.field_146218_h && mouseY >= this.searchBar.field_146210_g && mouseY < this.searchBar.field_146210_g + this.searchBar.field_146219_i) {
            this.searchBar.func_146180_a("");
        } else {
            this.searchBar.func_146192_a(mouseX, mouseY, button);
        }
        if (mouseX >= this.scrollBarXPos && mouseX <= this.scrollBarXPos + 7 && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int curY;
        boolean hasRecipes;
        boolean hasVariants;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isRecipeListDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.markDirty(false);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getAvailableRecipeCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.field_146125_m = hasVariants = this.container.hasVariants();
        this.btnNextRecipe.field_146125_m = hasVariants;
        this.btnSortName.field_146124_l = hasRecipes = this.container.getAvailableRecipeCount() > 0;
        this.btnSortHunger.field_146124_l = hasRecipes;
        this.btnSortSaturation.field_146124_l = hasRecipes;
        if (this.btnSortSoL != null) {
            this.btnSortSoL.field_146124_l = hasRecipes;
        }
        if (!this.container.hasSelection()) {
            curY = this.field_147009_r + 39 - this.noSelection.length / 2 * this.field_146289_q.field_78288_b;
            for (String s : this.noSelection) {
                this.field_146289_q.func_78261_a(s, this.field_147003_i + 23 + 27 - this.field_146289_q.func_78256_a(s) / 2, curY, -1);
                curY += this.field_146289_q.field_78288_b + 5;
            }
        } else if (this.container.isFurnaceRecipe()) {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 54, 174, 54, 54);
        } else {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 0, 174, 54, 54);
        }
        GuiContainer.func_73734_a((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getAvailableRecipeCount() == 0) {
            GuiContainer.func_73734_a((int)(this.field_147003_i + 97), (int)(this.field_147009_r + 7), (int)(this.field_147003_i + 168), (int)(this.field_147009_r + 85), (int)-1440603614);
            curY = this.field_147009_r + 39 - this.noIngredients.length / 2 * this.field_146289_q.field_78288_b;
            for (String s : this.noIngredients) {
                this.field_146289_q.func_78261_a(s, this.field_147003_i + 97 + 36 - this.field_146289_q.func_78256_a(s) / 2, curY, -1);
                curY += this.field_146289_q.field_78288_b + 5;
            }
        }
        this.hoverSlot = this.getSlotAtPosition(mouseX, mouseY);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (this.hoverSlot != null && this.hoverSlot instanceof SlotRecipe && event.itemStack == this.hoverSlot.func_75211_c()) {
            if (this.container.gotRecipeInfo() && this.container.canClickCraft(this.currentOffset * 3 + this.hoverSlot.getSlotIndex())) {
                if (this.container.isMissingTools()) {
                    event.toolTip.add("\u00a7c" + I18n.func_135052_a((String)"cookingforblockheads:missing_tools", (Object[])new Object[0]));
                } else if (Keyboard.isKeyDown((int)42)) {
                    event.toolTip.add("\u00a7a" + I18n.func_135052_a((String)"cookingforblockheads:click_to_craft_all", (Object[])new Object[0]));
                } else {
                    event.toolTip.add("\u00a7a" + I18n.func_135052_a((String)"cookingforblockheads:click_to_craft_one", (Object[])new Object[0]));
                }
            } else if (this.container.gotRecipeInfo() && this.container.canClickSmelt(this.currentOffset * 3 + this.hoverSlot.getSlotIndex())) {
                if (this.container.isMissingOven()) {
                    event.toolTip.add("\u00a7c" + I18n.func_135052_a((String)"cookingforblockheads:missing_oven", (Object[])new Object[0]));
                } else if (Keyboard.isKeyDown((int)42)) {
                    event.toolTip.add("\u00a7a" + I18n.func_135052_a((String)"cookingforblockheads:click_to_smelt_all", (Object[])new Object[0]));
                } else {
                    event.toolTip.add("\u00a7a" + I18n.func_135052_a((String)"cookingforblockheads:click_to_smelt_one", (Object[])new Object[0]));
                }
            } else {
                event.toolTip.add("\u00a7e" + I18n.func_135052_a((String)"cookingforblockheads:click_to_see_recipe", (Object[])new Object[0]));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.btnSortName.func_146115_a() && this.btnSortName.field_146124_l) {
            this.func_146283_a(this.btnSortName.getTooltipLines(), mouseX, mouseY);
        } else if (this.btnSortHunger.func_146115_a() && this.btnSortHunger.field_146124_l) {
            this.func_146283_a(this.btnSortHunger.getTooltipLines(), mouseX, mouseY);
        } else if (this.btnSortSaturation.func_146115_a() && this.btnSortSaturation.field_146124_l) {
            this.func_146283_a(this.btnSortSaturation.getTooltipLines(), mouseX, mouseY);
        } else if (this.btnSortSoL != null && this.btnSortSoL.func_146115_a() && this.btnSortSoL.field_146124_l) {
            this.func_146283_a(this.btnSortSoL.getTooltipLines(), mouseX, mouseY);
        }
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getAvailableRecipeCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    public int getAPIVersion() {
        return 1;
    }

    public String getModName() {
        return "Cooking for Blockheads";
    }

    public boolean isMouseTweaksDisabled() {
        return true;
    }

    public boolean isWheelTweakDisabled() {
        return true;
    }

    public boolean isCraftingOutputSlot(Object o, Object o1) {
        return false;
    }

    public Object getModContainer() {
        return this.field_147002_h;
    }

    public int getModSlotCount(Object o) {
        return this.field_147002_h.field_75151_b.size();
    }

    public Object getModSlot(Object o, int i) {
        return this.field_147002_h.func_75139_a(i);
    }

    public Object getModSelectedSlot(Object o, int i) {
        return null;
    }

    public void clickModSlot(Object o, Object o1, int i, boolean b) {
    }

    public void disableRMBDragIfRequired(Object o, Object o1, boolean b) {
    }

    public GuiButtonSort[] getSortButtons() {
        return this.sortButtons;
    }
}

