/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashSet;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import pl.asie.computronics.cc.CCRadarProxy;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.RadarUtils;
import pl.asie.computronics.util.TableUtils;
import pl.asie.lib.api.tile.IBattery;
import pl.asie.lib.api.tile.IBatteryProvider;
import pl.asie.lib.tile.BatteryBasic;
import pl.asie.lib.util.EnergyConverter;

public class TileRadar
extends TileEntityPeripheralBase
implements IBatteryProvider {
    public TileRadar() {
        super("radar", 0.0);
        this.registerBattery((IBattery)new BatteryBasic(EnergyConverter.convertEnergy((double)(Config.RADAR_ENERGY_COST_OC * (double)Config.RADAR_RANGE * 3.5), (String)"OC", (String)"RF")));
    }

    public boolean canUpdate() {
        return Config.MUST_UPDATE_TILE_ENTITIES;
    }

    private int getDistance(Arguments args) {
        if (args.isInteger(0)) {
            return args.checkInteger(0);
        }
        return Config.RADAR_RANGE;
    }

    private AxisAlignedBB getBounds(int d) {
        int distance = Math.min(d, Config.RADAR_RANGE);
        if (distance < 1) {
            distance = 1;
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)distance, (double)distance, (double)distance);
    }

    public boolean extractFromBattery(double amount) {
        double amt = EnergyConverter.convertEnergy((double)amount, (String)"OC", (String)"RF");
        if (this.getBatteryProvider().getEnergyStored() < amt) {
            return false;
        }
        this.getBatteryProvider().extract(-1, amt, false);
        return true;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Radar", "Trumbour Technology", "Detectotron M1", new String[0]);
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all entities detected within the specified or the maximum range")
    @Optional.Method(modid="OpenComputers")
    public Object[] getEntities(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.75;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded) || this.extractFromBattery(energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, bounds, EntityPlayer.class));
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all players detected within the specified or the maximum range")
    @Optional.Method(modid="OpenComputers")
    public Object[] getPlayers(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded) || this.extractFromBattery(energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, bounds, EntityPlayer.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all mobs detected within the specified or the maximum range")
    @Optional.Method(modid="OpenComputers")
    public Object[] getMobs(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 1.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded) || this.extractFromBattery(energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getEntities(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, bounds, EntityLiving.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Callback(doc="function([distance:number]):table; Returns a list of all items detected within the specified or the maximum range")
    @Optional.Method(modid="OpenComputers")
    public Object[] getItems(Context context, Arguments args) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        int distance = this.getDistance(args);
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance * 2.0;
        if (((Connector)this.node()).tryChangeBuffer(0.0 - energyNeeded) || this.extractFromBattery(energyNeeded)) {
            AxisAlignedBB bounds = this.getBounds(distance);
            entities.addAll(RadarUtils.getItems(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, bounds, EntityItem.class));
            context.pause(0.5);
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return CCRadarProxy.getMethodNames();
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return CCRadarProxy.callMethod(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, computer, context, method, arguments, this);
    }
}

