/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.lighting;

import cofh.repack.codechicken.lib.lighting.PlanarLightModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Vector3;

public class LightModel
implements CCRenderState.IVertexOperation {
    public static final int operationIndex = CCRenderState.registerOperation();
    public static LightModel standardLightModel = new LightModel().setAmbient(new Vector3(0.4, 0.4, 0.4)).addLight(new Light(new Vector3(0.2, 1.0, -0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6))).addLight(new Light(new Vector3(-0.2, 1.0, 0.7)).setDiffuse(new Vector3(0.6, 0.6, 0.6)));
    private Vector3 ambient = new Vector3();
    private Light[] lights = new Light[8];
    private int lightCount;

    public LightModel addLight(Light light) {
        this.lights[this.lightCount++] = light;
        return this;
    }

    public LightModel setAmbient(Vector3 vector3) {
        this.ambient.set(vector3);
        return this;
    }

    public int apply(int n, Vector3 vector3) {
        Vector3 vector32 = this.ambient.copy();
        for (int i = 0; i < this.lightCount; ++i) {
            Light light = this.lights[i];
            double d = light.position.dotProduct(vector3);
            double d2 = d > 0.0 ? 1.0 : 0.0;
            vector32.x += light.ambient.x + d2 * light.diffuse.x * d;
            vector32.y += light.ambient.y + d2 * light.diffuse.y * d;
            vector32.z += light.ambient.z + d2 * light.diffuse.z * d;
        }
        if (vector32.x > 1.0) {
            vector32.x = 1.0;
        }
        if (vector32.y > 1.0) {
            vector32.y = 1.0;
        }
        if (vector32.z > 1.0) {
            vector32.z = 1.0;
        }
        vector32.multiply((double)(n >>> 24) / 255.0, (double)(n >> 16 & 0xFF) / 255.0, (double)(n >> 8 & 0xFF) / 255.0);
        return (int)(vector32.x * 255.0) << 24 | (int)(vector32.y * 255.0) << 16 | (int)(vector32.z * 255.0) << 8 | n & 0xFF;
    }

    @Override
    public boolean load() {
        if (!CCRenderState.computeLighting) {
            return false;
        }
        CCRenderState.pipeline.addDependency(CCRenderState.normalAttrib);
        CCRenderState.pipeline.addDependency(CCRenderState.colourAttrib);
        return true;
    }

    @Override
    public void operate() {
        CCRenderState.setColour(this.apply(CCRenderState.colour, CCRenderState.normal));
    }

    @Override
    public int operationID() {
        return operationIndex;
    }

    public PlanarLightModel reducePlanar() {
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray[i] = this.apply(-1, Rotation.axes[i]);
        }
        return new PlanarLightModel(nArray);
    }

    public static class Light {
        public Vector3 ambient = new Vector3();
        public Vector3 diffuse = new Vector3();
        public Vector3 position;

        public Light(Vector3 vector3) {
            this.position = vector3.copy().normalize();
        }

        public Light setDiffuse(Vector3 vector3) {
            this.diffuse.set(vector3);
            return this;
        }

        public Light setAmbient(Vector3 vector3) {
            this.ambient.set(vector3);
            return this;
        }
    }
}

