/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.repack.codechicken.lib.asm.InsnComparator;
import cofh.repack.codechicken.lib.asm.InsnListSection;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class ASMBlock {
    public InsnListSection list;
    private BiMap<String, LabelNode> labels;

    public ASMBlock(InsnListSection insnListSection, BiMap<String, LabelNode> biMap) {
        this.list = insnListSection;
        this.labels = biMap;
    }

    public ASMBlock(InsnListSection insnListSection) {
        this(insnListSection, (BiMap<String, LabelNode>)HashBiMap.create());
    }

    public ASMBlock(InsnList insnList) {
        this(new InsnListSection(insnList));
    }

    public ASMBlock() {
        this(new InsnListSection());
    }

    public LabelNode getOrAdd(String string) {
        LabelNode labelNode = this.get(string);
        if (labelNode == null) {
            labelNode = new LabelNode();
            this.labels.put((Object)string, (Object)labelNode);
        }
        return labelNode;
    }

    public LabelNode get(String string) {
        return (LabelNode)this.labels.get((Object)string);
    }

    public void replaceLabels(Map<LabelNode, LabelNode> map, Set<LabelNode> set) {
        Object object;
        for (AbstractInsnNode object2 : this.list) {
            switch (object2.getType()) {
                case 8: {
                    object = object2.clone(map);
                    if (object == object2) break;
                    if (set.contains(object)) {
                        throw new IllegalStateException("LabelNode cannot be a part of two InsnLists");
                    }
                    this.list.replace(object2, (AbstractInsnNode)object);
                    break;
                }
                case 7: 
                case 11: 
                case 12: 
                case 14: {
                    this.list.replace(object2, object2.clone(map));
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            object = (String)this.labels.inverse().get(entry.getKey());
            if (object == null) continue;
            this.labels.put(object, entry.getValue());
        }
    }

    public void replaceLabels(Map<LabelNode, LabelNode> map) {
        this.replaceLabels(map, Collections.EMPTY_SET);
    }

    public void replaceLabel(String string, LabelNode labelNode) {
        LabelNode labelNode2 = this.get(string);
        if (labelNode2 != null) {
            this.replaceLabels((Map<LabelNode, LabelNode>)ImmutableMap.of((Object)labelNode2, (Object)labelNode));
        }
    }

    public ASMBlock mergeLabels(ASMBlock aSMBlock) {
        if (this.labels.isEmpty() || aSMBlock.labels.isEmpty()) {
            return this;
        }
        HashMap<LabelNode, LabelNode> hashMap = this.list.identityLabelMap();
        for (Map.Entry entry : aSMBlock.labels.entrySet()) {
            LabelNode labelNode = (LabelNode)this.labels.get(entry.getKey());
            if (labelNode == null) continue;
            hashMap.put(labelNode, (LabelNode)entry.getValue());
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry = aSMBlock.list.list.getFirst(); entry != null; entry = entry.getNext()) {
            if (entry.getType() != 8) continue;
            hashSet.add((LabelNode)entry);
        }
        this.replaceLabels(hashMap, hashSet);
        return this;
    }

    public ASMBlock pullLabels(ASMBlock aSMBlock) {
        aSMBlock.list.remove();
        return this.mergeLabels(aSMBlock);
    }

    public ASMBlock copy() {
        HashBiMap hashBiMap = HashBiMap.create();
        Map<LabelNode, LabelNode> map = this.list.cloneLabels();
        for (Map.Entry entry : this.labels.entrySet()) {
            hashBiMap.put(entry.getKey(), (Object)map.get(entry.getValue()));
        }
        return new ASMBlock(this.list.copy(map), (BiMap<String, LabelNode>)hashBiMap);
    }

    public ASMBlock applyLabels(InsnListSection insnListSection) {
        if (this.labels.isEmpty()) {
            return new ASMBlock(insnListSection);
        }
        Set set = this.labels.values();
        Set<LabelNode> set2 = InsnComparator.getControlFlowLabels(insnListSection);
        ASMBlock aSMBlock = new ASMBlock(insnListSection);
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        int n = 0;
        int n2 = 0;
        while (n < this.list.size() && n2 < insnListSection.size()) {
            AbstractInsnNode abstractInsnNode = this.list.get(n);
            if (!InsnComparator.insnImportant(abstractInsnNode, set)) {
                ++n;
                continue;
            }
            AbstractInsnNode abstractInsnNode2 = insnListSection.get(n2);
            if (!InsnComparator.insnImportant(abstractInsnNode2, set2)) {
                ++n2;
                continue;
            }
            if (abstractInsnNode.getOpcode() != abstractInsnNode2.getOpcode()) {
                throw new IllegalArgumentException("Lists do not match:\n" + this.list + "\n\n" + insnListSection);
            }
            switch (abstractInsnNode.getType()) {
                case 8: {
                    hashMap.put((LabelNode)abstractInsnNode, (LabelNode)abstractInsnNode2);
                    break;
                }
                case 7: {
                    hashMap.put(((JumpInsnNode)abstractInsnNode).label, ((JumpInsnNode)abstractInsnNode2).label);
                }
            }
            ++n;
            ++n2;
        }
        for (Map.Entry entry : this.labels.entrySet()) {
            aSMBlock.labels.put(entry.getKey(), hashMap.get(entry.getValue()));
        }
        return aSMBlock;
    }

    public InsnList rawListCopy() {
        return this.list.copy().list;
    }
}

