/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.Alchemy")
public class Alchemy {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack[] input, int tier, int lp) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new AlchemyRecipe(MTHelper.toStack(output), (int)((double)lp / 100.0), MTHelper.toStacks(input), tier)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        private AlchemyRecipe recipe;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (AlchemyRecipe r : AlchemyRecipeRegistry.recipes) {
                if (r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                this.recipe = r;
                break;
            }
            AlchemyRecipeRegistry.recipes.remove(this.recipe);
        }

        public boolean canUndo() {
            return AlchemyRecipeRegistry.recipes != null && this.recipe != null;
        }

        public void undo() {
            AlchemyRecipeRegistry.recipes.add(this.recipe);
        }

        public String describe() {
            return "Removing Alchemy Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Alchemy Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final AlchemyRecipe recipe;

        public Add(AlchemyRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AlchemyRecipeRegistry.recipes.add(this.recipe);
        }

        public boolean canUndo() {
            return AlchemyRecipeRegistry.recipes != null;
        }

        public void undo() {
            AlchemyRecipeRegistry.recipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Alchemy Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Alchemy Recipe for " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

