/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage.demonHoard;

import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.DemonHoardPacket;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.DemonType;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class DemonPacketRegistry {
    public static Map<String, DemonHoardPacket> packetMap = new HashMap<String, DemonHoardPacket>();

    public static boolean registerDemonPacket(String string, DemonHoardPacket packet) {
        if (!packetMap.containsValue(string) && packet != null) {
            packetMap.put(string, packet);
            return true;
        }
        return false;
    }

    public static String getDemonPacketName(DemonType type, int tier, boolean spawnGuardian) {
        DemonHoardPacket packet;
        float totalChance = 0.0f;
        for (Map.Entry<String, DemonHoardPacket> entry : packetMap.entrySet()) {
            packet = entry.getValue();
            if (packet == null) continue;
            totalChance += packet.getRelativeChance(type, tier, spawnGuardian);
        }
        for (Map.Entry<String, DemonHoardPacket> entry : packetMap.entrySet()) {
            packet = entry.getValue();
            if (packet == null) continue;
            float relativeChance = packet.getRelativeChance(type, tier, spawnGuardian);
            if (relativeChance >= totalChance) {
                return entry.getKey();
            }
            totalChance -= relativeChance;
        }
        return "";
    }

    public static int spawnDemons(TEDemonPortal teDemonPortal, World world, int x, int y, int z, DemonType type, int tier, boolean spawnGuardian) {
        return DemonPacketRegistry.spawnDemons(teDemonPortal, world, x, y, z, DemonPacketRegistry.getDemonPacketName(type, tier, spawnGuardian), type, tier, spawnGuardian);
    }

    public static int spawnDemons(TEDemonPortal teDemonPortal, World world, int x, int y, int z, String name, DemonType type, int tier, boolean spawnGuardian) {
        DemonHoardPacket packet = packetMap.get(name);
        if (packet != null) {
            return packet.summonDemons(teDemonPortal, world, x, y, z, type, tier, spawnGuardian);
        }
        return 0;
    }
}

