/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.auxiliary;

import com.github.namikon.blocklimiter.BlockLimiter;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.auxiliary.IntHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;

public class BlockInfo {
    private String _mFQBN;
    private String _mModID;
    private String _mBlockName;
    private List<Integer> _mBannedDimensions = new ArrayList<Integer>();
    private boolean _mGlobalDenied = false;

    public BlockInfo(String pBlockConfig) {
        this.InitBlockInfoInstance(pBlockConfig);
    }

    public boolean isDenied(GameRegistry.UniqueIdentifier pUID, int pDimensionID) {
        boolean tResult = false;
        BlockLimiter.Logger.debug((Object)String.format("Checking against block %s:%s", this._mModID, this._mBlockName));
        if (pUID.modId.equalsIgnoreCase(this._mModID) && pUID.name.equalsIgnoreCase(this._mBlockName)) {
            BlockLimiter.Logger.debug((Object)"Target Block found, ModID and Name match");
            if (this._mBannedDimensions.contains(pDimensionID) || this._mGlobalDenied) {
                tResult = true;
            }
        }
        BlockLimiter.Logger.debug((Object)("Result is " + tResult));
        return tResult;
    }

    public String getInfoString() {
        String tInfo = String.format("Block %s:%s ", this._mModID, this._mBlockName);
        if (this._mGlobalDenied) {
            tInfo = tInfo + "[ALL]";
        } else {
            tInfo = tInfo + "[In DIM: ";
            boolean tFirst = true;
            for (Integer i : this._mBannedDimensions) {
                if (tFirst) {
                    tFirst = false;
                } else {
                    tInfo = tInfo + ", ";
                }
                tInfo = tInfo + String.format("%d", i);
            }
            tInfo = tInfo + "]";
        }
        return tInfo;
    }

    private void InitBlockInfoInstance(String pBlockConfig) {
        BlockLimiter.Logger.debug((Object)("pBlockConfig: " + pBlockConfig));
        String[] tBlockInfoArray1 = pBlockConfig.split(";");
        this._mFQBN = tBlockInfoArray1[0];
        String[] tBlockInfoArray2 = this._mFQBN.split(":");
        if (tBlockInfoArray2.length < 2) {
            BlockLimiter.Logger.warn((Object)("BlockDefinition " + pBlockConfig + " is invalid and will be ignored"));
            throw new IllegalArgumentException(pBlockConfig);
        }
        this._mModID = tBlockInfoArray2[0];
        this._mBlockName = tBlockInfoArray2[1];
        Block tTestBlock = GameRegistry.findBlock((String)this._mModID, (String)this._mBlockName);
        if (tTestBlock == null) {
            BlockLimiter.Logger.warn((Object)("The Block " + this._mFQBN + " can't be found in the Gameregistry and will be ignored"));
            throw new IllegalArgumentException(pBlockConfig);
        }
        if (tBlockInfoArray1.length == 1) {
            BlockLimiter.Logger.debug((Object)("New restrictive Block added: " + tTestBlock.func_149739_a() + " Block is denied in ALL dimensions"));
            this._mGlobalDenied = true;
        } else {
            for (int i = 1; i < tBlockInfoArray1.length; ++i) {
                if (!IntHelper.tryParse((String)tBlockInfoArray1[i])) continue;
                this.AddBlacklistedDim(Integer.parseInt(tBlockInfoArray1[i]));
            }
            BlockLimiter.Logger.debug((Object)("New restrictive Block added: " + tTestBlock.func_149739_a() + " Block is denied in " + this._mBannedDimensions.size() + " dimension(s)"));
        }
    }

    private void AddBlacklistedDim(int pDimID) {
        for (Integer i : this._mBannedDimensions) {
            if (i != pDimID) continue;
            return;
        }
        this._mBannedDimensions.add(pDimID);
    }
}

