/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.cache;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.NBTConverter;
import betterquesting.network.handlers.NetCacheSync;
import betterquesting.questing.QuestDatabase;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class QuestCache
implements IExtendedEntityProperties {
    public static final ResourceLocation LOC_QUEST_CACHE = new ResourceLocation("betterquesting", "quest_cache");
    private final HashSet<UUID> visibleQuests = new HashSet();
    private final HashSet<UUID> activeQuests = new HashSet();
    private final TreeSet<QResetTime> resetSchedule = new TreeSet((o1, o2) -> o1.questID.equals(o2.questID) ? 0 : Long.compare(o1.time, o2.time));
    private final HashSet<UUID> autoClaims = new HashSet();
    private final HashSet<UUID> markedDirty = new HashSet();

    public void init(Entity entity, World world) {
    }

    public synchronized ImmutableSet<UUID> getActiveQuests() {
        return ImmutableSet.copyOf(this.activeQuests);
    }

    public synchronized ImmutableSet<UUID> getVisibleQuests() {
        return ImmutableSet.copyOf(this.visibleQuests);
    }

    public synchronized ImmutableSet<UUID> getPendingAutoClaims() {
        return ImmutableSet.copyOf(this.autoClaims);
    }

    public synchronized QResetTime[] getScheduledResets() {
        return this.resetSchedule.toArray(new QResetTime[0]);
    }

    public synchronized void markQuestDirty(UUID questID) {
        this.markedDirty.add(questID);
    }

    public synchronized void markQuestClean(UUID questID) {
        this.markedDirty.remove(questID);
    }

    public synchronized void cleanAllQuests() {
        this.markedDirty.clear();
    }

    public synchronized ImmutableSet<UUID> getDirtyQuests() {
        return ImmutableSet.copyOf(this.markedDirty);
    }

    public synchronized void updateCache(@Nonnull EntityPlayer player) {
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        Set questDB = QuestingAPI.getAPI(ApiReference.QUEST_DB).entrySet();
        ArrayList tmpVisible = new ArrayList();
        ArrayList tmpActive = new ArrayList();
        ArrayList<QResetTime> tmpReset = new ArrayList<QResetTime>();
        ArrayList tmpAutoClaim = new ArrayList();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry entry : questDB) {
            if (((IQuest)entry.getValue()).isUnlocked(uuid) || ((IQuest)entry.getValue()).getProperty(NativeProps.LOCKED_PROGRESS).booleanValue()) {
                int repeat = ((IQuest)entry.getValue()).getProperty(NativeProps.REPEAT_TIME);
                NBTTagCompound ue = ((IQuest)entry.getValue()).getCompletionInfo(uuid);
                if (ue == null && ((IQuest)entry.getValue()).getTasks().size() <= 0 || ((IQuest)entry.getValue()).canSubmit(player)) {
                    tmpActive.add(entry.getKey());
                } else if (ue != null) {
                    if (repeat >= 0 && ((IQuest)entry.getValue()).hasClaimed(uuid)) {
                        long altTime = ue.func_74763_f("timestamp");
                        if (altTime > currentTime) {
                            altTime = currentTime;
                        }
                        if (repeat > 1 && !((IQuest)entry.getValue()).getProperty(NativeProps.REPEAT_REL).booleanValue()) {
                            altTime -= altTime % (long)repeat;
                        }
                        tmpReset.add(new QResetTime((UUID)entry.getKey(), altTime + (long)(repeat * 50)));
                    }
                    if (!((IQuest)entry.getValue()).hasClaimed(uuid) && ((IQuest)entry.getValue()).getProperty(NativeProps.AUTO_CLAIM).booleanValue()) {
                        tmpAutoClaim.add(entry.getKey());
                    }
                }
            }
            if (!QuestCache.isQuestShown((IQuest)entry.getValue(), uuid, player)) continue;
            tmpVisible.add(entry.getKey());
        }
        this.visibleQuests.clear();
        this.visibleQuests.addAll(tmpVisible);
        this.activeQuests.clear();
        this.activeQuests.addAll(tmpActive);
        this.resetSchedule.clear();
        this.resetSchedule.addAll(tmpReset);
        this.autoClaims.clear();
        this.autoClaims.addAll(tmpAutoClaim);
        if (player instanceof EntityPlayerMP) {
            NetCacheSync.sendSync((EntityPlayerMP)player);
        }
    }

    public synchronized void saveNBTData(NBTTagCompound tags) {
        tags.func_74782_a("visibleQuests", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds((Collection<UUID>)this.getVisibleQuests()));
        tags.func_74782_a("activeQuests", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds((Collection<UUID>)this.getActiveQuests()));
        tags.func_74782_a("autoClaims", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds((Collection<UUID>)this.getPendingAutoClaims()));
        tags.func_74782_a("markedDirty", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds((Collection<UUID>)this.getDirtyQuests()));
        NBTTagList tagSchedule = new NBTTagList();
        for (QResetTime entry : this.getScheduledResets()) {
            NBTTagCompound tagEntry = NBTConverter.UuidValueType.QUEST.writeId(entry.questID);
            tagEntry.func_74772_a("time", entry.time);
            tagSchedule.func_74742_a((NBTBase)tagEntry);
        }
        tags.func_74782_a("resetSchedule", (NBTBase)tagSchedule);
    }

    public synchronized void loadNBTData(NBTTagCompound nbt) {
        this.visibleQuests.clear();
        this.activeQuests.clear();
        this.resetSchedule.clear();
        this.autoClaims.clear();
        this.markedDirty.clear();
        this.visibleQuests.addAll(NBTConverter.UuidValueType.QUEST.readIds(nbt, "visibleQuests"));
        this.activeQuests.addAll(NBTConverter.UuidValueType.QUEST.readIds(nbt, "activeQuests"));
        this.autoClaims.addAll(NBTConverter.UuidValueType.QUEST.readIds(nbt, "autoClaims"));
        this.markedDirty.addAll(NBTConverter.UuidValueType.QUEST.readIds(nbt, "markedDirty"));
        NBTTagList tagList = nbt.func_150295_c("resetSchedule", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagEntry = tagList.func_150305_b(i);
            NBTConverter.UuidValueType.QUEST.tryReadId(tagEntry).ifPresent(uuid -> this.resetSchedule.add(new QResetTime((UUID)uuid, tagEntry.func_74763_f("time"))));
        }
    }

    public static boolean isQuestShown(IQuest quest, UUID uuid, EntityPlayer player) {
        if (quest == null || uuid == null) {
            return false;
        }
        EnumQuestVisibility vis = quest.getProperty(NativeProps.VISIBILITY);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit(player) || vis == EnumQuestVisibility.ALWAYS) {
            return true;
        }
        if (vis == EnumQuestVisibility.HIDDEN) {
            return false;
        }
        if (vis == EnumQuestVisibility.SECRET) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (BQ_Settings.viewMode) {
            return true;
        }
        if (vis == EnumQuestVisibility.UNLOCKED) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (vis == EnumQuestVisibility.NORMAL) {
            if (quest.isComplete(uuid) || quest.isUnlocked(uuid)) {
                return true;
            }
            return QuestDatabase.INSTANCE.getAll(quest.getRequirements()).allMatch(q -> q.isUnlocked(uuid));
        }
        if (vis == EnumQuestVisibility.COMPLETED) {
            return quest.isComplete(uuid);
        }
        if (vis == EnumQuestVisibility.CHAIN) {
            if (quest.getRequirements().isEmpty()) {
                return true;
            }
            return QuestDatabase.INSTANCE.getAll(quest.getRequirements()).anyMatch(q -> QuestCache.isQuestShown(q, uuid, player));
        }
        return true;
    }

    public class QResetTime
    implements Comparable<QResetTime> {
        public final UUID questID;
        public final long time;

        private QResetTime(UUID questID, long time) {
            this.questID = questID;
            this.time = time;
        }

        @Override
        public int compareTo(QResetTime o) {
            return Long.compare(o.time, this.time);
        }

        public boolean equals(Object o) {
            if (!(o instanceof QResetTime)) {
                return false;
            }
            return ((QResetTime)o).questID.equals(this.questID);
        }
    }
}

