/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.render;

import cpw.mods.fml.relauncher.ReflectionHelper;
import fox.spiteful.avaritia.Lumberjack;
import fox.spiteful.avaritia.render.LudicrousRenderEvents;
import fox.spiteful.avaritia.render.ShaderCallback;
import fox.spiteful.avaritia.render.ShaderHelper;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.ARBShaderObjects;

public class CosmicRenderShenanigans {
    public static final ShaderCallback shaderCallback;
    public static float[] lightlevel;
    public static String[] lightmapobf;
    public static boolean inventoryRender;
    public static float cosmicOpacity;
    private static Field mapfield;

    public static void useShader() {
        ShaderHelper.useShader(ShaderHelper.cosmicShader, shaderCallback);
    }

    public static void releaseShader() {
        ShaderHelper.releaseShader();
    }

    public static void setLightFromLocation(World world, int x, int y, int z) {
        if (world == null) {
            CosmicRenderShenanigans.setLightLevel(1.0f);
            return;
        }
        int coord = world.func_72802_i(x, y, z, 0);
        int[] map = null;
        try {
            map = (int[])mapfield.get(Minecraft.func_71410_x().field_71460_t);
        }
        catch (Exception e) {
            Lumberjack.log(Level.ERROR, e, "Failure to get light map");
        }
        if (map == null) {
            CosmicRenderShenanigans.setLightLevel(1.0f);
            return;
        }
        int mx = coord % 65536 / 16;
        int my = coord / 65536 / 16;
        int lightcolour = map[my * 16 + mx];
        CosmicRenderShenanigans.setLightLevel((float)(lightcolour >> 16 & 0xFF) / 256.0f, (float)(lightcolour >> 8 & 0xFF) / 256.0f, (float)(lightcolour & 0xFF) / 256.0f);
    }

    public static void setLightLevel(float level) {
        CosmicRenderShenanigans.setLightLevel(level, level, level);
    }

    public static void setLightLevel(float r, float g, float b) {
        CosmicRenderShenanigans.lightlevel[0] = Math.max(0.0f, Math.min(1.0f, r));
        CosmicRenderShenanigans.lightlevel[1] = Math.max(0.0f, Math.min(1.0f, g));
        CosmicRenderShenanigans.lightlevel[2] = Math.max(0.0f, Math.min(1.0f, b));
    }

    public static void bindItemTexture() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
    }

    static {
        lightlevel = new float[3];
        lightmapobf = new String[]{"lightmapColors", "field_78504_Q", "U"};
        inventoryRender = false;
        cosmicOpacity = 1.0f;
        shaderCallback = new ShaderCallback(){

            @Override
            public void call(int shader) {
                Minecraft mc = Minecraft.func_71410_x();
                float yaw = 0.0f;
                float pitch = 0.0f;
                float scale = 1.0f;
                if (!inventoryRender) {
                    yaw = (float)((double)(mc.field_71439_g.field_70177_z * 2.0f) * Math.PI / 360.0);
                    pitch = -((float)((double)(mc.field_71439_g.field_70125_A * 2.0f) * Math.PI / 360.0));
                } else {
                    scale = 25.0f;
                }
                int time2 = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time2");
                ARBShaderObjects.glUniform1fARB((int)time2, (float)mc.field_71439_g.field_70173_aa);
                int x = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"yaw");
                ARBShaderObjects.glUniform1fARB((int)x, (float)yaw);
                int z = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"pitch");
                ARBShaderObjects.glUniform1fARB((int)z, (float)pitch);
                int l = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"lightlevel");
                ARBShaderObjects.glUniform3fARB((int)l, (float)lightlevel[0], (float)lightlevel[1], (float)lightlevel[2]);
                int lightmix = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"lightmix");
                ARBShaderObjects.glUniform1fARB((int)lightmix, (float)0.2f);
                int uvs = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"cosmicuvs");
                ARBShaderObjects.glUniformMatrix2ARB((int)uvs, (boolean)false, (FloatBuffer)LudicrousRenderEvents.cosmicUVs);
                int s = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"externalScale");
                ARBShaderObjects.glUniform1fARB((int)s, (float)scale);
                int o = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"opacity");
                ARBShaderObjects.glUniform1fARB((int)o, (float)cosmicOpacity);
            }
        };
        mapfield = ReflectionHelper.findField(EntityRenderer.class, (String[])lightmapobf);
    }
}

