/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.tiles.TileEntityChestBase;

public class TileEntityTenaciousChest
extends TileEntityChestBase {
    public static int SORT_TIME = 200;
    private boolean needItemSort = true;
    private int ticksUntilSort = 0;
    private boolean getStackFlagsForSort = true;

    public TileEntityTenaciousChest() {
        super("blockTenaciousChest", 9, 3);
        this.notifyOnInventoryChanged = true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.needItemSort) {
            if (this.field_145850_b.field_72995_K) {
                this.needItemSort = false;
            } else if (this.ticksUntilSort < 1) {
                this.needItemSort = false;
                this.ticksUntilSort = SORT_TIME;
                this.doItemSort();
            } else {
                --this.ticksUntilSort;
            }
        }
    }

    public void flagForSort(int t) {
        this.needItemSort = true;
        this.ticksUntilSort = Math.min(this.ticksUntilSort, t);
    }

    public void flagForSort() {
        this.flagForSort(SORT_TIME);
    }

    protected void doItemSort() {
        ItemStack stack;
        int i;
        int lastFreeSlot = -1;
        int firstFreeSlot = -1;
        int lastSlot = this.func_70302_i_() - 1;
        HashMap<HashableItemWithoutSize, Integer> items = new HashMap<HashableItemWithoutSize, Integer>();
        for (i = lastSlot; i >= 0; --i) {
            stack = this.inventorySlots[i];
            if (stack == null) {
                if (lastFreeSlot == -1) {
                    lastFreeSlot = i;
                }
                firstFreeSlot = i;
                continue;
            }
            if (stack.field_77994_a <= 0) continue;
            HashableItemWithoutSize key = new HashableItemWithoutSize(stack);
            if (items.containsKey(key)) {
                items.put(key, -1);
                continue;
            }
            if (stack.field_77994_a < 2) {
                items.put(key, -1);
                continue;
            }
            items.put(key, i);
        }
        if (lastFreeSlot != -1) {
            for (Map.Entry entry : items.entrySet()) {
                Integer v = (Integer)entry.getValue();
                if (v == -1 || !this.splitOneFromSlot(v, lastFreeSlot > v ? lastFreeSlot : firstFreeSlot)) continue;
                this.flagForSort(0);
                return;
            }
        }
        for (i = lastSlot; i >= 1; --i) {
            stack = this.inventorySlots[i];
            if (stack == null || stack.field_77994_a <= 1 || !this.isHighestNumberedSlotWithItem(i, stack)) continue;
            ItemStack copy = stack.func_77946_l();
            int moved = --copy.field_77994_a;
            this.getStackFlagsForSort = false;
            ItemStack leftover = TjUtil.addToInventory(copy, (IInventory)this, 0, i - 1);
            if (leftover != null && i < lastSlot) {
                leftover = TjUtil.addToInventory(leftover, (IInventory)this, i + 1, lastSlot);
            }
            this.getStackFlagsForSort = true;
            if (leftover != null) {
                moved -= leftover.field_77994_a;
            }
            if (moved <= 0) continue;
            stack.field_77994_a -= moved;
            this.markDirty(false);
            this.flagForSort(0);
            return;
        }
    }

    private boolean splitOneFromSlot(int oldSlot, int newSlot) {
        ItemStack stack2;
        ItemStack stack = this.inventorySlots[oldSlot];
        if (stack == null || stack.field_77994_a < 2) {
            return false;
        }
        int amt = oldSlot < newSlot ? 1 : stack.field_77994_a - 1;
        this.inventorySlots[newSlot] = stack2 = this.inventorySlots[oldSlot].func_77979_a(amt);
        this.markDirty(false);
        return true;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.inventorySlots[slot] == null) {
            return true;
        }
        if (stack != null) {
            if (!this.isHighestNumberedSlotWithItem(slot, stack)) {
                return true;
            }
            if (this.inventorySlots[slot].field_77994_a == 1 && this.calledBySortingGolem(5)) {
                return true;
            }
        }
        return false;
    }

    private boolean calledBySortingGolem(int callStackDepth) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length < (callStackDepth += 2)) {
            return false;
        }
        String className = stackTraceElements[callStackDepth].getClassName();
        if ("thaumcraft.common.entities.ai.inventory.AISortingGoto".equals(className) || "thaumcraft.common.entities.ai.inventory.AISortingPlace".equals(stackTraceElements[callStackDepth].getClassName())) {
            return true;
        }
        return "thaumcraft.common.entities.golems.GolemHelper".equals(className) && "findSomethingSortCore".equals(stackTraceElements[callStackDepth].getMethodName());
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        if (!this.field_145850_b.field_72995_K) {
            this.flagForSort(0);
        }
    }

    @Override
    public void func_70305_f() {
        super.func_70305_f();
        if (!this.field_145850_b.field_72995_K) {
            this.flagForSort(0);
        }
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        ItemStack stack = super.func_70301_a(slot);
        if (stack != null && this.getStackFlagsForSort) {
            this.flagForSort();
        }
        return stack;
    }

    protected boolean isHighestNumberedSlotWithItem(int slot, ItemStack stack) {
        for (int i = this.func_70302_i_() - 1; i >= 0; --i) {
            if (slot == i) {
                return true;
            }
            ItemStack stack2 = this.inventorySlots[i];
            if (stack2 == null || !TjUtil.areItemsEqualIgnoringSize(stack, stack2)) continue;
            return false;
        }
        return false;
    }
}

