/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.RenderShape;
import gcewing.architecture.ShapeKind;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import net.minecraft.util.EnumFacing;

public class RenderWindow
extends RenderShape {
    protected static ArchitectureCraftClient client;
    protected static WindowModels frameModels;
    protected static WindowModels cornerModels;
    protected static WindowModels mullionModels;
    protected boolean renderBase;
    protected boolean renderSecondary;
    protected ShapeKind.Window kind;

    protected static BaseModClient.IModel model(String name) {
        if (name != null) {
            return client.getModel("shape/window_" + name + ".smeg");
        }
        return null;
    }

    protected static BaseModClient.IModel[] models(String ... names) {
        BaseModClient.IModel[] result = new BaseModClient.IModel[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = RenderWindow.model(names[i]);
        }
        return result;
    }

    protected static BaseModClient.IModel[] models(int n, String name) {
        BaseModClient.IModel[] result = new BaseModClient.IModel[n];
        BaseModClient.IModel m = RenderWindow.model(name);
        for (int i = 0; i < n; ++i) {
            result[i] = m;
        }
        return result;
    }

    public static void init(ArchitectureCraftClient client) {
        RenderWindow.client = client;
        frameModels = new WindowModels(null, null, RenderWindow.models(4, "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models(4, "glass_edge"));
        cornerModels = new WindowModels(RenderWindow.model("corner_centre"), RenderWindow.models("corner_centre_end0", null, "corner_centre_end2", null), RenderWindow.models("corner_topbot", "frame_side", "corner_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models("corner_topbot_end1", "frame_end1", "corner_topbot_end1", "frame_end1"), RenderWindow.model("corner_glass"), RenderWindow.models("corner_glass_edge", "glass_edge", "corner_glass_edge", "glass_edge"));
        mullionModels = new WindowModels(RenderWindow.model("mullion_centre"), RenderWindow.models("mullion_centre_end0", null, "mullion_centre_end2", null), RenderWindow.models("mullion_topbot", "frame_side", "mullion_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models("mullion_glass_edge", "glass_edge", "mullion_glass_edge", "glass_edge"));
    }

    public RenderWindow(ShapeTE te, BaseModClient.ITexture[] textures, Trans3 t, BaseModClient.IRenderTarget target, boolean renderBase, boolean renderSecondary) {
        super(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
        this.kind = (ShapeKind.Window)te.shape.kind;
    }

    @Override
    protected void render() {
        switch (this.te.shape) {
            case WindowFrame: {
                this.renderWindow(frameModels);
                break;
            }
            case WindowCorner: {
                this.renderWindow(cornerModels);
                break;
            }
            case WindowMullion: {
                this.renderWindow(mullionModels);
            }
        }
    }

    protected void renderWindow(WindowModels models) {
        boolean[][] frame = this.getFrameFlags();
        if (this.renderBase) {
            this.renderModel(this.t, models.centre);
        }
        for (int i = 0; i <= 3; ++i) {
            int j = i - 1 & 3;
            int k = i + 1 & 3;
            Trans3 ts = this.t.t(this.kind.frameTrans[i]);
            if (this.renderBase) {
                if (frame[i][1]) {
                    this.renderModel(ts, models.side[i]);
                } else if (models.centreEnd != null) {
                    this.renderModel(this.t, models.centreEnd[i]);
                }
                if (frame[i][1] && !frame[j][1] || frame[i][0] && frame[j][2]) {
                    this.renderModel(ts, models.end0[i]);
                }
                if (frame[i][1] && !frame[k][1] || frame[i][2] && frame[k][0]) {
                    this.renderModel(ts, models.end1[i]);
                }
            }
            if (!this.renderSecondary || frame[i][1] || frame[i][3]) continue;
            this.renderModel(ts, models.glassEdge[i]);
        }
        if (this.renderSecondary) {
            this.renderModel(this.t, models.glass);
        }
    }

    protected void renderModel(Trans3 t, BaseModClient.IModel model) {
        if (model != null) {
            model.render(t, this.target, this.textures);
        }
    }

    protected boolean[][] getFrameFlags() {
        boolean[][] frame = new boolean[4][4];
        if (this.blockWorld == null) {
            for (int i = 0; i <= 3; ++i) {
                frame[i][1] = true;
            }
        } else {
            int i;
            EnumFacing[] gdir = new EnumFacing[4];
            ShapeTE[] neighbour = new ShapeTE[4];
            for (i = 0; i <= 3; ++i) {
                gdir[i] = this.t.t(this.kind.frameSides[i]);
            }
            for (i = 0; i <= 3; ++i) {
                if (this.kind.frameAlways[i]) {
                    frame[i][1] = true;
                    continue;
                }
                ShapeTE nte = this.getConnectedNeighbourGlobal(this.te, gdir[i]);
                if (nte == null) {
                    frame[i][1] = true;
                    continue;
                }
                int j = i - 1 & 3;
                int k = i + 1 & 3;
                if (this.getConnectedNeighbourGlobal(nte, gdir[j]) == null) {
                    frame[j][2] = true;
                }
                if (this.getConnectedNeighbourGlobal(nte, gdir[k]) == null) {
                    frame[k][0] = true;
                }
                if (nte.secondaryBlockState == null) continue;
                frame[i][3] = true;
            }
        }
        return frame;
    }

    protected void dumpFrameFlags(boolean[][] frame) {
        if (this.te != null && this.te.secondaryBlockState != null) {
            System.out.printf("RenderWindow.getFrameFlags:\n", new Object[0]);
            for (int i = 0; i <= 3; ++i) {
                System.out.printf("Side %s: %s %s %s\n", i, frame[i][0], frame[i][1], frame[i][2]);
            }
        }
    }

    protected ShapeTE getConnectedNeighbourGlobal(ShapeTE te, EnumFacing globalDir) {
        return this.kind.getConnectedWindowGlobal(te, globalDir);
    }

    protected void debug(String fmt, Object ... args) {
        if (this.blockWorld != null && this.te.secondaryBlockState != null) {
            System.out.printf(fmt, args);
        }
    }

    protected static class WindowModels {
        public BaseModClient.IModel centre;
        public BaseModClient.IModel[] centreEnd;
        public BaseModClient.IModel[] side;
        public BaseModClient.IModel[] end0;
        public BaseModClient.IModel[] end1;
        public BaseModClient.IModel glass;
        public BaseModClient.IModel[] glassEdge;

        public WindowModels(BaseModClient.IModel centre, BaseModClient.IModel[] centreEnd, BaseModClient.IModel[] side, BaseModClient.IModel[] end0, BaseModClient.IModel[] end1, BaseModClient.IModel glass, BaseModClient.IModel[] glassEdge) {
            this.centre = centre;
            this.centreEnd = centreEnd;
            this.side = side;
            this.end0 = end0;
            this.end1 = end1;
            this.glass = glass;
            this.glassEdge = glassEdge;
        }
    }
}

