/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.BlockPos;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;

public class BaseUtils {
    public static EnumFacing[] facings = EnumFacing.values();
    public static EnumFacing[] horizontalFacings = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};

    public static int abs(int x) {
        return x >= 0 ? x : -x;
    }

    public static int min(int x, int y) {
        return x < y ? x : y;
    }

    public static int max(int x, int y) {
        return x > y ? x : y;
    }

    public static double min(double x, double y) {
        return x < y ? x : y;
    }

    public static double max(double x, double y) {
        return x > y ? x : y;
    }

    public static int clampIndex(int x, int n) {
        return BaseUtils.max(0, BaseUtils.min(x, n - 1));
    }

    public static int ifloor(double x) {
        return (int)Math.floor(x);
    }

    public static int iround(double x) {
        return (int)Math.round(x);
    }

    public static int iceil(double x) {
        return (int)Math.ceil(x);
    }

    public static Object[] arrayOf(Collection c) {
        int n = c.size();
        Object[] result = new Object[n];
        int i = 0;
        for (Object item : c) {
            result[i++] = item;
        }
        return result;
    }

    public static Class classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getFieldDef(Class cls, String unobfName, String obfName) {
        try {
            Field field;
            try {
                field = cls.getDeclaredField(unobfName);
            }
            catch (NoSuchFieldException e) {
                field = cls.getDeclaredField(obfName);
            }
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot find field %s or %s of %s", unobfName, obfName, cls.getName()), e);
        }
    }

    public static Object getField(Object obj, String unobfName, String obfName) {
        Field field = BaseUtils.getFieldDef(obj.getClass(), unobfName, obfName);
        return BaseUtils.getField(obj, field);
    }

    public static Object getField(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getIntField(Object obj, Field field) {
        try {
            return field.getInt(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object obj, String unobfName, String obfName, Object value) {
        Field field = BaseUtils.getFieldDef(obj.getClass(), unobfName, obfName);
        BaseUtils.setField(obj, field, value);
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setIntField(Object obj, Field field, int value) {
        try {
            field.setInt(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethodDef(Class cls, String unobfName, String obfName, Class ... params) {
        try {
            Method meth;
            try {
                meth = cls.getDeclaredMethod(unobfName, params);
            }
            catch (NoSuchMethodException e) {
                meth = cls.getDeclaredMethod(obfName, params);
            }
            meth.setAccessible(true);
            return meth;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot find method %s or %s of %s", unobfName, obfName, cls.getName()), e);
        }
    }

    public static Object invokeMethod(Object target, Method meth, Object ... args) {
        try {
            return meth.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int packedColor(double red, double green, double blue) {
        return (int)(red * 255.0) << 16 | (int)(green * 255.0) << 8 | (int)(blue * 255.0);
    }

    public static int turnToFace(EnumFacing local, EnumFacing global) {
        return BaseUtils.turnToFaceEast(local) - BaseUtils.turnToFaceEast(global) & 3;
    }

    public static int turnToFaceEast(EnumFacing f) {
        switch (f) {
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
        }
        return 0;
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, BaseTileEntity te) {
        ItemStack stack = new ItemStack(block, size);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.writeToItemStackNBT(tag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static BlockPos readBlockPos(DataInput data) {
        try {
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            return new BlockPos(x, y, z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBlockPos(DataOutput data, BlockPos pos) {
        try {
            data.writeInt(pos.getX());
            data.writeInt(pos.getY());
            data.writeInt(pos.getZ());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getWorldDimensionId(World world) {
        return world.field_73011_w.field_76574_g;
    }

    public static EnumDifficulty getWorldDifficulty(World world) {
        return world.field_73013_u;
    }

    public static World getChunkWorld(Chunk chunk) {
        return chunk.field_76637_e;
    }

    public static Map getChunkTileEntityMap(Chunk chunk) {
        return chunk.field_150816_i;
    }

    public static AxisAlignedBB newAxisAlignedBB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return AxisAlignedBB.func_72330_a((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
    }

    public static boolean getGameRuleBoolean(GameRules gr, String name) {
        return gr.func_82766_b(name);
    }

    public static void scmPreparePlayer(ServerConfigurationManager scm, EntityPlayerMP player, WorldServer world) {
        scm.func_72375_a(player, world);
    }

    public static void setBoundingBoxOfEntity(Entity entity, AxisAlignedBB box) {
        entity.field_70121_D.func_72324_b(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public static String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    public static MapStorage getPerWorldStorage(World world) {
        return world.perWorldStorage;
    }

    public static EnumFacing oppositeFacing(EnumFacing dir) {
        return facings[dir.ordinal() ^ 1];
    }

    public static boolean facingAxesEqual(EnumFacing facing1, EnumFacing facing2) {
        return (facing1.ordinal() & 6) == (facing2.ordinal() & 6);
    }

    public static int getStackMetadata(ItemStack stack) {
        return stack.func_77973_b().func_77647_b(stack.func_77960_j());
    }

    public static MovingObjectPosition newMovingObjectPosition(Vec3 hitVec, int sideHit, BlockPos pos) {
        return new MovingObjectPosition(pos.x, pos.y, pos.z, sideHit, hitVec, true);
    }

    public static AxisAlignedBB boxUnion(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.func_111270_a(box2);
    }

    public static MinecraftServer getMinecraftServer() {
        return MinecraftServer.func_71276_C();
    }

    public static WorldServer getWorldForDimension(int id) {
        return BaseUtils.getMinecraftServer().func_71218_a(id);
    }

    public static <T extends WorldSavedData> T getWorldData(World world, Class<T> cls, String name) {
        MapStorage storage = world.perWorldStorage;
        WorldSavedData result = storage.func_75742_a(cls, name);
        if (result == null) {
            try {
                result = (WorldSavedData)cls.getConstructor(String.class).newInstance(name);
                storage.func_75745_a(name, result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)result;
    }
}

