/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.volcano;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Volcano
extends BaseStructureStart {
    protected BlockMetaPair fluid;
    protected BlockMetaPair mountainMaterial;
    protected BlockMetaPair shaftMaterial;
    protected int maxDepth = 2;
    protected int maxHeight = 50;
    protected int radius = 50;
    protected int shaftRadius = 2;
    protected int calderaRadius = 6;
    protected int falloffWidth = 9;
    protected int magmaChamberWidth;
    protected int magmaChamberHeight;
    protected Gradient testGrad;
    protected boolean hasMagmaChamber = false;

    public boolean hasMagmaChamber() {
        return this.hasMagmaChamber;
    }

    public void setHasMagmaChamber(boolean hasMagmaChamber) {
        this.hasMagmaChamber = hasMagmaChamber;
    }

    public Volcano(World world, int chunkX, int chunkZ, Random rand) {
        super(world, chunkX, chunkZ, rand);
        int startX = CoordHelper.chunkToMinBlock(chunkX) + MathHelper.func_76136_a((Random)rand, (int)0, (int)15);
        int startZ = CoordHelper.chunkToMinBlock(chunkZ) + MathHelper.func_76136_a((Random)rand, (int)0, (int)15);
        StructureBoundingBox bb = new StructureBoundingBox(startX - this.radius, startZ - this.radius, startX + this.radius, startZ + this.radius);
        this.setStructureBoundingBox(bb);
        AmunRa.LOGGER.debug("Generating Volcano at {}/{}", new Object[]{startX, startZ});
        this.testGrad = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.testGrad.setFrequency(0.05f);
        this.calderaRadius = MathHelper.func_76136_a((Random)rand, (int)5, (int)7);
        this.shaftRadius = MathHelper.func_76136_a((Random)rand, (int)1, (int)3);
        this.radius = MathHelper.func_76136_a((Random)rand, (int)46, (int)56);
        this.magmaChamberWidth = MathHelper.func_76136_a((Random)rand, (int)(this.radius - 10), (int)this.radius);
        this.magmaChamberHeight = MathHelper.func_76136_a((Random)rand, (int)(this.radius / 2), (int)this.radius);
    }

    protected double getHeightFromDistance(double distance) {
        return (double)this.maxHeight * (((double)this.radius - distance) / (double)this.radius);
    }

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] blocks, byte[] metas) {
        super.generateChunk(chunkX, chunkZ, blocks, metas);
        StructureBoundingBox chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        StructureBoundingBox myBB = this.getStructureBoundingBox();
        if (!chunkBB.func_78884_a(myBB)) {
            return false;
        }
        int fallbackGround = this.getWorldGroundLevel();
        if (this.groundLevel == -1) {
            this.groundLevel = Volcano.getAverageGroundLevel(blocks, metas, this.getStructureBoundingBox(), chunkBB, fallbackGround);
            if (this.groundLevel == -1) {
                this.groundLevel = fallbackGround;
            }
        }
        int xCenter = myBB.func_78881_e();
        int zCenter = myBB.func_78891_g();
        double sqRadius = Math.pow(this.radius, 2.0);
        int faloffRadius = this.radius - this.falloffWidth;
        for (int x = myBB.field_78897_a; x <= myBB.field_78893_d; ++x) {
            for (int z = myBB.field_78896_c; z <= myBB.field_78892_f; ++z) {
                if (!chunkBB.func_78890_b(x, 64, z)) continue;
                int lowestBlock = Volcano.getHighestSpecificBlock(blocks, metas, CoordHelper.abs2rel(x, chunkX), CoordHelper.abs2rel(z, chunkZ), this.mountainMaterial.getBlock(), this.mountainMaterial.getMetadata());
                if (lowestBlock == -1) {
                    lowestBlock = this.maxDepth;
                }
                int xRel = x - xCenter;
                int zRel = z - zCenter;
                int sqDistance = xRel * xRel + zRel * zRel;
                double heightAtCalderaBorder = this.getHeightFromDistance(this.calderaRadius) + (double)this.groundLevel;
                double fluidHeight = this.getHeightFromDistance(this.shaftRadius) + (double)this.groundLevel;
                if ((double)sqDistance <= sqRadius) {
                    int y;
                    int height;
                    double distance = Math.sqrt(sqDistance);
                    if (distance <= (double)this.shaftRadius) {
                        height = (int)fluidHeight;
                        height = (int)(heightAtCalderaBorder - ((double)height - heightAtCalderaBorder));
                    } else {
                        height = (int)this.getHeightFromDistance(distance) + this.groundLevel;
                        if (distance > (double)faloffRadius && lowestBlock < height && this.groundLevel > lowestBlock) {
                            double faloffFactor = (distance - (double)faloffRadius) / (double)this.falloffWidth;
                            height = (int)this.lerp(height, lowestBlock, faloffFactor);
                        }
                        if (distance <= (double)this.calderaRadius) {
                            height = (int)(heightAtCalderaBorder - ((double)height - heightAtCalderaBorder));
                        }
                        double noise = this.testGrad.getNoise((float)x, (float)z);
                        height = (int)((long)height + Math.round(noise *= 8.0));
                    }
                    if (height > 255) {
                        height = 255;
                    }
                    if (height < lowestBlock) {
                        height = lowestBlock;
                    }
                    if (distance < (double)(this.shaftRadius + 2)) {
                        for (y = this.maxDepth + 1; y < height; ++y) {
                            if (distance <= (double)this.shaftRadius) {
                                Volcano.placeBlockAbs(blocks, metas, x, y, z, chunkX, chunkZ, this.fluid);
                                continue;
                            }
                            Volcano.placeBlockAbs(blocks, metas, x, y, z, chunkX, chunkZ, this.shaftMaterial);
                        }
                    } else {
                        for (y = lowestBlock; y < height; ++y) {
                            Volcano.placeBlockAbs(blocks, metas, x, y, z, chunkX, chunkZ, this.mountainMaterial);
                        }
                    }
                }
                if (!this.hasMagmaChamber) continue;
                for (int y = 0; y < this.magmaChamberHeight; ++y) {
                    if (xRel * xRel / this.magmaChamberWidth * this.magmaChamberWidth + y * y / this.magmaChamberHeight * this.magmaChamberHeight + zRel * zRel / this.magmaChamberWidth * this.magmaChamberWidth > 1) continue;
                    Volcano.placeBlockAbs(blocks, metas, x, y + this.maxDepth, z, chunkX, chunkZ, this.fluid);
                }
            }
        }
        return true;
    }

    public BlockMetaPair getFluid() {
        return this.fluid;
    }

    public void setFluid(BlockMetaPair fluid) {
        this.fluid = fluid;
    }

    public BlockMetaPair getMountainMaterial() {
        return this.mountainMaterial;
    }

    public void setMountainMaterial(BlockMetaPair mountainMaterial) {
        this.mountainMaterial = mountainMaterial;
    }

    public BlockMetaPair getShaftMaterial() {
        return this.shaftMaterial;
    }

    public void setShaftMaterial(BlockMetaPair shaftMaterial) {
        this.shaftMaterial = shaftMaterial;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

