/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.astronomy.AngleDistance;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public abstract class AmunraWorldProvider
extends WorldProviderSpace
implements IExitHeight,
ISolarLevel {
    protected float solarLevel = -1.0f;

    protected abstract float getRelativeGravity();

    public boolean isDaytime() {
        return this.field_76579_a.field_73008_k < 4;
    }

    public float getGravity() {
        return 0.08f * (1.0f - this.getRelativeGravity());
    }

    public double getFuelUsageMultiplier() {
        return this.getRelativeGravity();
    }

    public float getFallDamageModifier() {
        return this.getRelativeGravity();
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= AmunRa.config.planetDefaultTier;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public boolean hasAtmosphere() {
        return this.getCelestialBody().atmosphere.size() > 0;
    }

    public boolean hasClouds() {
        return this.hasAtmosphere();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float p_76562_1_, float p_76562_2_) {
        float dayFactor = MathHelper.func_76134_b((float)(p_76562_1_ * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (dayFactor < 0.0f) {
            dayFactor = 0.0f;
        }
        if (dayFactor > 1.0f) {
            dayFactor = 1.0f;
        }
        Vector3 baseColor = this.getFogColor();
        float r = baseColor.floatX();
        float g = baseColor.floatY();
        float b = baseColor.floatZ();
        return Vec3.func_72443_a((double)(r *= dayFactor * 0.94f + 0.06f), (double)(g *= dayFactor * 0.94f + 0.06f), (double)(b *= dayFactor * 0.91f + 0.09f));
    }

    public float getSolarSize() {
        CelestialBody body = this.getCelestialBody();
        if (body instanceof Moon) {
            Moon moon = (Moon)body;
            return 1.0f / moon.getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
        }
        return 1.0f / body.getRelativeDistanceFromCenter().unScaledDistance;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarLevel < 0.0f) {
            this.solarLevel = AstronomyHelper.getSolarEnergyMultiplier(this.getCelestialBody(), !this.getCelestialBody().atmosphere.isEmpty());
        }
        return this.solarLevel;
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        Vector3 skyColorBase = this.getSkyColor();
        float celestialAngle = this.field_76579_a.func_72826_c(partialTicks);
        float dayFactor = MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (dayFactor < 0.0f) {
            dayFactor = 0.0f;
        }
        if (dayFactor > 1.0f) {
            dayFactor = 1.0f;
        }
        float red = skyColorBase.floatX();
        float green = skyColorBase.floatY();
        float blue = skyColorBase.floatZ();
        return Vec3.func_72443_a((double)(red *= dayFactor), (double)(green *= dayFactor), (double)(blue *= dayFactor));
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float factor = this.field_76579_a.getSunBrightnessBody(par1) + this.getAmunBrightnessFactor(par1);
        if (factor > 1.0f) {
            factor = 1.0f;
        }
        return factor;
    }

    public float getSunBrightnessFactor(float par1) {
        float factor = this.field_76579_a.getSunBrightnessFactor(par1) + this.getAmunBrightnessFactor(par1);
        if (factor > 1.0f) {
            factor = 1.0f;
        }
        return factor;
    }

    protected float getAmunBrightnessFactor(float partialTicks) {
        CelestialBody curBody = this.getCelestialBody();
        if (curBody instanceof Moon) {
            Moon moon = (Moon)curBody;
            curBody = moon.getParentPlanet();
        }
        AngleDistance ad = AstronomyHelper.projectBodyToSky(curBody, (CelestialBody)AmunRa.instance.starAmun, partialTicks, this.field_76579_a.func_72820_D());
        float brightnessFactor = 1.0f - (MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * (float)Math.PI * 2.0f + ad.angle)) * 2.0f + 0.5f);
        if (brightnessFactor < 0.0f) {
            brightnessFactor = 0.0f;
        }
        if (brightnessFactor > 1.0f) {
            brightnessFactor = 1.0f;
        }
        brightnessFactor = 1.0f - brightnessFactor;
        return (float)((double)brightnessFactor * 0.8 / (double)ad.distance);
    }
}

