/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import de.katzenpapst.amunra.helper.GuiHelper;
import de.katzenpapst.amunra.item.SubItem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemTricorder
extends SubItem {
    public ItemTricorder(String name, String assetName) {
        super(name, assetName);
    }

    public ItemTricorder(String name, String assetName, String info) {
        super(name, assetName, info);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            return itemStackIn;
        }
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        float gravity = 1.0f;
        float thermalLevel = 0.0f;
        double solarLevel = 1.0;
        int dayLength = -1;
        ArrayList<String> atmospheres = new ArrayList<String>();
        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
            gravity = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getGravity();
            gravity = 1.0f - gravity / 0.08f;
            thermalLevel = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getThermalLevelModifier();
        }
        if (worldIn.field_73011_w instanceof ISolarLevel) {
            solarLevel = ((ISolarLevel)worldIn.field_73011_w).getSolarEnergyMultiplier();
        }
        if (worldIn.field_73011_w instanceof WorldProviderSpace) {
            dayLength = (int)((WorldProviderSpace)worldIn.field_73011_w).getDayLength();
            CelestialBody curBody = ((WorldProviderSpace)worldIn.field_73011_w).getCelestialBody();
            for (IAtmosphericGas gas : curBody.atmosphere) {
                atmospheres.add(GuiHelper.getGasName(gas));
            }
        } else if (worldIn.field_73011_w.field_76574_g == 0) {
            dayLength = 24000;
            for (IAtmosphericGas gas : GalacticraftCore.planetOverworld.atmosphere) {
                atmospheres.add(GuiHelper.getGasName(gas));
            }
        }
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.gravity", new Object[]{twoDForm.format(gravity *= 9.81f)}));
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.temperature", new Object[]{twoDForm.format(thermalLevel)}));
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.solar", new Object[]{twoDForm.format(solarLevel)}));
        if (dayLength == -1) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.daylength", new Object[]{new ChatComponentTranslation("item.baseItem.tricorder.message.unknown", new Object[0])}));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.daylength", new Object[]{GuiHelper.formatTime(dayLength, false)}));
        }
        if (atmospheres.isEmpty()) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.atmosphere", new Object[]{new ChatComponentTranslation("item.baseItem.tricorder.message.none", new Object[0])}));
        } else {
            StringBuilder builder = new StringBuilder();
            boolean isFirst = true;
            for (String str : atmospheres) {
                if (!isFirst) {
                    builder.append(", ");
                }
                isFirst = false;
                builder.append(str);
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.baseItem.tricorder.message.atmosphere", new Object[]{builder.toString()}));
        }
        return itemStackIn;
    }
}

