/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.item.ItemDamagePair;
import de.katzenpapst.amunra.item.SubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBasicMulti
extends Item
implements ItemBlockDesc.IBlockShiftDesc {
    protected ArrayList<SubItem> subItems = null;
    protected Map<String, Integer> nameDamageMapping = null;

    public ItemBasicMulti(String name) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b(name);
        this.subItems = new ArrayList();
        this.nameDamageMapping = new HashMap<String, Integer>();
    }

    public ItemStack getItemStack(String name, int count) {
        return this.getItemStack(this.getDamageByName(name), count);
    }

    public ItemStack getItemStack(int damage, int count) {
        if (this.subItems.get(damage) == null) {
            throw new IllegalArgumentException("SubItem with damage " + damage + " does not exist in " + this.func_77658_a());
        }
        return new ItemStack((Item)this, count, damage);
    }

    public ItemDamagePair addSubItem(int damage, SubItem item) {
        if (damage >= this.subItems.size()) {
            this.subItems.ensureCapacity(damage);
            while (damage >= this.subItems.size()) {
                this.subItems.add(null);
            }
        }
        if (this.subItems.get(damage) != null) {
            throw new IllegalArgumentException("SubItem with damage " + damage + " already exists in " + this.func_77658_a());
        }
        String itemName = item.func_77658_a();
        if (this.nameDamageMapping.get(itemName) != null) {
            throw new IllegalArgumentException("SubItem with name " + itemName + " already exists in " + this.func_77658_a());
        }
        this.nameDamageMapping.put(itemName, damage);
        this.subItems.add(damage, item);
        return new ItemDamagePair(this, damage);
    }

    public int getDamageByName(String name) {
        if (!this.nameDamageMapping.containsKey(name)) {
            return -1;
        }
        return this.nameDamageMapping.get(name);
    }

    public void register() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a(), (String)"GalacticraftAmunRa");
    }

    public CreativeTabs func_77640_w() {
        return AmunRa.arTab;
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (SubItem item : this.subItems) {
            if (item == null) continue;
            item.func_94581_a(register);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + this.getSubItem(stack.func_77960_j()).func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int p_77617_1_) {
        return this.subItems.get(p_77617_1_).func_77617_a(0);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.subItems.get(stack.func_77960_j()).getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack p_77650_1_) {
        return this.subItems.get(p_77650_1_.func_77960_j()).func_77650_f(p_77650_1_);
    }

    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List<ItemStack> p_150895_3_) {
        for (int i = 0; i < this.subItems.size(); ++i) {
            if (this.subItems.get(i) == null) continue;
            p_150895_3_.add(new ItemStack(p_150895_1_, 1, i));
        }
    }

    public int func_77647_b(int p_77647_1_) {
        return p_77647_1_;
    }

    public SubItem getSubItem(int damage) {
        if (damage >= this.subItems.size() || this.subItems.get(damage) == null) {
            throw new IllegalArgumentException("Requested invalid SubItem " + damage + " from " + this.func_77658_a());
        }
        return this.subItems.get(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List<String> p_77624_3_, boolean p_77624_4_) {
        SubItem item = this.getSubItem(p_77624_1_.func_77960_j());
        item.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        String info = item.getItemInfo();
        if (info != null) {
            info = GCCoreUtil.translate((String)info);
            p_77624_3_.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(info, 150));
        }
    }

    public ItemStack func_77654_b(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        return this.getSubItem(p_77654_1_.func_77960_j()).func_77654_b(p_77654_1_, p_77654_2_, p_77654_3_);
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return this.getSubItem(p_77626_1_.func_77960_j()).func_77626_a(p_77626_1_);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getSubItem(stack.func_77960_j()).func_77661_b(stack);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        return this.getSubItem(itemStackIn.func_77960_j()).func_77659_a(itemStackIn, worldIn, player);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.getSubItem(stack.func_77960_j()).onLeftClickEntity(stack, player, entity);
    }

    public int getFuelDuration(int meta) {
        return this.getSubItem(meta).getFuelDuration();
    }

    public String getShiftDescription(int meta) {
        return null;
    }

    public boolean showDescription(int meta) {
        return false;
    }
}

