/*
 * Decompiled with CFR 0.152.
 */
package advsolar.common.items;

import advsolar.common.AdvancedSolarPanel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedSolarHelmet
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    private double maxCharge;
    private double transferLimit;
    private int tier;
    private int ticker;
    private int generating;
    private int genDay;
    private int genNight;
    private int solarType;
    private int energyPerDamage;
    private double damageAbsorptionRatio;
    private double baseAbsorptionRatio;
    private boolean initialized;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean noSunWorld;
    private boolean wetBiome;

    public ItemAdvancedSolarHelmet(ItemArmor.ArmorMaterial par2EnumArmorMaterial, int par3, int par4, int htype) {
        super(par2EnumArmorMaterial, par3, par4);
        this.solarType = htype;
        this.maxCharge = 1000000.0;
        this.transferLimit = 3000.0;
        this.tier = 3;
        if (this.solarType == 1) {
            this.genDay = AdvancedSolarPanel.advGenDay;
            this.genNight = AdvancedSolarPanel.advGenNight;
            this.maxCharge = 1000000.0;
            this.transferLimit = 3000.0;
            this.tier = 3;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.baseAbsorptionRatio = 0.15;
        }
        if (this.solarType == 2) {
            this.genDay = AdvancedSolarPanel.hGenDay;
            this.genNight = AdvancedSolarPanel.hGenNight;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 4;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.baseAbsorptionRatio = 0.15;
        }
        if (this.solarType == 3) {
            this.genDay = AdvancedSolarPanel.uhGenDay;
            this.genNight = AdvancedSolarPanel.uhGenNight;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 4;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.baseAbsorptionRatio = 0.15;
        }
        this.func_77637_a(AdvancedSolarPanel.ic2Tab);
        this.func_77656_e(27);
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        if (worldObj.field_72995_K) {
            return;
        }
        this.gainFuel(player);
        if (this.solarType == 2 || this.solarType == 3) {
            int airLevel = player.func_70086_ai();
            if (ElectricItem.manager.canUse(itemStack, 1000.0) && airLevel < 100) {
                player.func_70050_g(airLevel + 200);
                ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)((EntityPlayer)null));
            }
        }
        if (this.generating > 0) {
            double sentPacket;
            int energyLeft = this.generating;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (energyLeft > 0) {
                    if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IElectricItem)) continue;
                    sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70460_b[i], (double)energyLeft, 4, false, false);
                    energyLeft = (int)((double)energyLeft - sentPacket);
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                if (energyLeft > 0) {
                    if (player.field_71071_by.field_70462_a[j] == null || !(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IElectricItem)) continue;
                    sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70462_a[j], (double)energyLeft, 4, false, false);
                    energyLeft = (int)((double)energyLeft - sentPacket);
                    continue;
                }
                return;
            }
        }
    }

    public int gainFuel(EntityPlayer player) {
        if (this.ticker++ % ItemAdvancedSolarHelmet.tickRate() == 0) {
            this.updateVisibility(player);
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.generating = 0 + this.genDay;
            return this.generating;
        }
        if (this.skyIsVisible) {
            this.generating = 0 + this.genNight;
            return this.generating;
        }
        this.generating = 0;
        return this.generating;
    }

    public void updateVisibility(EntityPlayer player) {
        this.wetBiome = player.field_70170_p.func_72959_q().func_76935_a((int)player.field_70165_t, (int)player.field_70161_v).func_76744_g() > 0;
        this.noSunWorld = player.field_70170_p.field_73011_w.field_76576_e;
        Boolean rainWeather = this.wetBiome && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        this.sunIsUp = player.field_70170_p.func_72935_r() && rainWeather == false;
        this.skyIsVisible = player.field_70170_p.func_72937_j((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v) && !this.noSunWorld;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    private double getBaseAbsorptionRatio() {
        return this.baseAbsorptionRatio;
    }

    public static int tickRate() {
        return 128;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        if (this.solarType == 1) {
            this.field_77791_bV = IIconRegister2.func_94245_a("advancedsolarpanel:AdvSolarHelmet");
        }
        if (this.solarType == 2) {
            this.field_77791_bV = IIconRegister2.func_94245_a("advancedsolarpanel:HybridSolarHelmet");
        }
        if (this.solarType == 3) {
            this.field_77791_bV = IIconRegister2.func_94245_a("advancedsolarpanel:UltimateSolarHelmet");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.solarType == 1) {
            return "advancedsolarpanel:textures/armor/advancedSolarHelmet.png";
        }
        if (this.solarType == 2) {
            return "advancedsolarpanel:textures/armor/hybridSolarHelmet.png";
        }
        if (this.solarType == 3) {
            return "advancedsolarpanel:textures/armor/ultimateSolarHelmet.png";
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        if (this.solarType == 1) {
            return EnumRarity.uncommon;
        }
        if (this.solarType == 2) {
            return EnumRarity.rare;
        }
        return EnumRarity.epic;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }
}

