/*
 * Decompiled with CFR 0.152.
 */
package me.mkdomain.azauthmod.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import me.mkdomain.azauthmod.AzAuthMod;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.client.CPacketLoginStart;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CPacketLoginStart.class})
public class MixinServerLoginStart {
    @Shadow
    private GameProfile field_149305_a;

    @Inject(method={"readPacketData"}, at={@At(value="TAIL")})
    public void readPacketData(PacketBuffer buf, CallbackInfo ci) throws IOException {
        if (buf.readableBytes() < 1) {
            throw new IOException("Didn't authenticate");
        }
        String inputToken = buf.func_150789_c(1000);
        if (!MixinServerLoginStart.validateToken(this.field_149305_a.getName(), inputToken)) {
            throw new IOException("Bad authentication.");
        }
    }

    private static boolean validateToken(String username, String token) {
        try {
            String resp;
            URL url = new URL("https://ftbhungary.hu/api/auth/verify");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            try {
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/json");
                conn.setDoOutput(true);
                conn.getOutputStream().write(("{\"access_token\":\"" + token + "\"}").getBytes(StandardCharsets.UTF_8));
                resp = new String(IOUtils.toByteArray((InputStream)conn.getInputStream()), StandardCharsets.UTF_8).intern();
            }
            catch (IOException ex) {
                try {
                    resp = new String(IOUtils.toByteArray((InputStream)conn.getErrorStream()), StandardCharsets.UTF_8).intern();
                }
                catch (Exception ignored) {
                    throw ex;
                }
            }
            try {
                JsonObject root = new JsonParser().parse(resp).getAsJsonObject();
                return (!root.has("status") || !root.get("status").getAsString().equalsIgnoreCase("error")) && root.has("username") && root.get("username").getAsString().equals(username);
            }
            catch (JsonParseException | ClassCastException ex) {
                AzAuthMod.getLogger().error("Error during authentication", ex);
                return false;
            }
        }
        catch (Exception e) {
            AzAuthMod.getLogger().error("Error during authentication", (Throwable)e);
            return false;
        }
    }
}

