/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.util;

import bre.smoothfont.util.Logger;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    private int vertShader;
    private int fragShader;
    private int program = this.createProgram();
    private String verr;
    private String ferr;
    private String lerr;

    public ShaderProgram(String vertShaderSrc, String fragShaderSrc) {
        if (this.program != 0) {
            this.vertShader = this.compileShader(35633, vertShaderSrc);
            this.fragShader = this.compileShader(35632, fragShaderSrc);
            if (this.vertShader != 0 && this.fragShader != 0) {
                if (!this.linkProgram(this.program, this.vertShader, this.fragShader)) {
                    this.detachShaders();
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        }
    }

    public int getProgram() {
        return this.program;
    }

    private int createProgram() {
        int program = GL20.glCreateProgram();
        if (program == 0) {
            Logger.error("Shader program creation failed.");
            return 0;
        }
        return program;
    }

    private int compileShader(int type, String shaderSource) {
        int shader = GL20.glCreateShader((int)type);
        if (shader == 0) {
            Logger.error("Shader creation failed. Type=" + type);
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)shaderSource);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            int len = GL20.glGetShaderi((int)shader, (int)35716);
            String err = GL20.glGetShaderInfoLog((int)shader, (int)len);
            Logger.error("Shader compilation failed. (Type=" + type + "): " + err);
            if (type == 35633) {
                this.verr = err;
            } else if (type == 35632) {
                this.ferr = err;
            }
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private boolean linkProgram(int program, int vertShader, int fragShader) {
        GL20.glAttachShader((int)program, (int)fragShader);
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            int len = GL20.glGetProgrami((int)program, (int)35716);
            this.lerr = GL20.glGetProgramInfoLog((int)program, (int)len);
            Logger.error("Linking shader program failed: " + this.lerr);
            return false;
        }
        return true;
    }

    private void detachShaders() {
        if (this.vertShader != 0) {
            GL20.glDetachShader((int)this.program, (int)this.vertShader);
        }
        if (this.fragShader != 0) {
            GL20.glDetachShader((int)this.program, (int)this.fragShader);
        }
    }

    private void dispose() {
        if (this.vertShader != 0) {
            GL20.glDeleteShader((int)this.vertShader);
            this.vertShader = 0;
        }
        if (this.fragShader != 0) {
            GL20.glDeleteShader((int)this.fragShader);
            this.fragShader = 0;
        }
        if (this.program != 0) {
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    public void disposeShader() {
        this.detachShaders();
        this.dispose();
    }
}

