/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.proxy;

import bre.smoothfont.CommandSfont;
import bre.smoothfont.ExternalFontManager;
import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontShader;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.config.OldConfig;
import bre.smoothfont.config.PlayerConfig;
import bre.smoothfont.gui.GuiHandler;
import bre.smoothfont.handler.GuiScreenEventHandler;
import bre.smoothfont.handler.KeyBindEventHandler;
import bre.smoothfont.handler.TimerEventHandler;
import bre.smoothfont.mod_SmoothFont;
import bre.smoothfont.proxy.CommonProxy;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    Minecraft mc = Minecraft.func_71410_x();
    public static KeyBinding openGuiKey;
    private File configDirectory;
    private Thread genGlyphImgThread;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Logger.init(event);
        this.configDirectory = event.getModConfigurationDirectory();
        File globalConfigFile = new File(this.configDirectory, "smoothfont" + File.separator + "smoothfont" + ".cfg");
        if (ModLib.checkDevEnv()) {
            GlobalConfig.existingConfigFile = globalConfigFile.exists();
        }
        CommonConfig.globalConfig = new GlobalConfig(globalConfigFile);
        CommonConfig.currentConfig = CommonConfig.globalConfig;
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            if (!GlobalConfig.existingConfigFile) {
                OldConfig.readConfig(oldConfigFile);
                CommonConfig.globalConfig.takeoverOldConfigValues();
                CommonConfig.globalConfig.saveConfig();
                Logger.info("New global config file took over the parameters in the old config file.");
            }
            File oldConfigBackup = new File(this.configDirectory, "smoothfont" + File.separator + "oldConfig.bak");
            try {
                if (oldConfigBackup.exists()) {
                    oldConfigBackup.delete();
                }
                oldConfigFile.renameTo(oldConfigBackup);
            }
            catch (Exception e) {
                Logger.error("Configuration file access error. (OldConfig)");
                e.printStackTrace();
            }
        }
        if (CommonConfig.globalConfig.enablePerPlayerConfig) {
            String playerHashStr = ModLib.checkDevEnv() ? "debugDummy" : DigestUtils.md5Hex((String)Minecraft.func_71410_x().func_110432_I().func_148255_b());
            PlayerConfig.playerConfigFile = new File(this.configDirectory, "smoothfont" + File.separator + "player-" + playerHashStr + ".cfg");
            if (PlayerConfig.playerConfigFile.exists()) {
                PlayerConfig.readPlayerConfig();
            }
        }
        GlobalConfig.configLoaded = true;
        ExternalFontManager.getInstance().forceRegistrationWin10PerUserFonts();
        ExternalFontManager.getInstance().registerExternalFonts();
        GLUtils.checkGlFuncSupported();
        FontShader.getInstance().setupShader();
        this.genGlyphImgThread = null;
        if (CommonConfig.currentConfig.runMode == 0 && CommonConfig.currentConfig.useOSFont) {
            if (CommonConfig.globalConfig.asyncInit) {
                this.genGlyphImgThread = new Thread(){

                    @Override
                    public void run() {
                        FontRasterizer.getInstance().initFontCache(true);
                    }
                };
                this.genGlyphImgThread.start();
            } else {
                FontRasterizer.getInstance().initFontCache(false);
            }
        }
        if (this.genGlyphImgThread == null) {
            FontRendererHook.initAfterConfigLoaded();
        }
        super.preInit(event);
    }

    @Override
    public void init() {
        if (!CommonConfig.globalConfig.disableInGameConfigGui) {
            FMLCommonHandler.instance().bus().register((Object)new KeyBindEventHandler());
            openGuiKey = new KeyBinding("smoothfont.key.guiOpen", 199, "smoothfont.key.categories");
            ClientRegistry.registerKeyBinding((KeyBinding)openGuiKey);
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod_SmoothFont.instance, (IGuiHandler)new GuiHandler());
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)CommandSfont.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new TimerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiScreenEventHandler());
        super.init();
    }

    @Override
    public void postInit() {
        if (this.genGlyphImgThread != null) {
            try {
                this.genGlyphImgThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FontRendererHook.initAfterConfigLoaded();
        }
        if (CommonConfig.globalConfig.workaroundKeepOriginalWidthValues) {
            FontRendererHookList hookList = new FontRendererHookList(){

                @Override
                public boolean process(FontRendererHook frh) {
                    if (frh.fontRenderer == ClientProxy.this.mc.field_71466_p) {
                        frh.keepMcFontWidth = true;
                        frh.reloadResources();
                    }
                    return true;
                }
            };
            hookList.executeAll();
        }
        for (String modid : CommonConfig.globalConfig.modsNotUsingHighPRC) {
            if (!Loader.isModLoaded((String)modid)) continue;
            CommonConfig.globalConfig.mcStdRendererNotUseHighPRC = true;
            FontRendererHookList hookList = new FontRendererHookList(){

                @Override
                public boolean process(FontRendererHook frh) {
                    String cls = frh.fontRenderer.getClass().getName();
                    if (frh.precisionMode == 0 && "net.minecraft.client.gui.FontRenderer".equals(cls)) {
                        frh.precisionMode = 1;
                    }
                    return true;
                }
            };
            hookList.executeAll();
            break;
        }
        super.postInit();
        FontRendererHook.modLoaded = true;
    }
}

