/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util;

import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.event.MTEventManager;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.util.EventList;
import crafttweaker.util.SuppressErrorFlag;
import crafttweaker.zenscript.GlobalRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.type.expand.ZenExpandMember;
import stanhebben.zenscript.type.natives.JavaMethod;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.impl.util.IVersionChecker;
import youyihj.zenutils.impl.util.InvalidCraftTweakerVersionException;
import youyihj.zenutils.impl.util.ReflectUtils;

public final class InternalUtils {
    private static final Map<String, SuppressErrorFlag> suppressErrorScriptMap = new HashMap<String, SuppressErrorFlag>();
    private static final List<EventList> ALL_EVENT_LISTS = new ArrayList<EventList>();
    public static boolean hardFailMode = false;
    private static boolean suppressErrorSingleScriptMode = false;
    private static boolean isFirstSetMode = true;

    private InternalUtils() {
    }

    public static void checkDataMap(IData data) {
        if (!(data instanceof DataMap)) {
            CraftTweakerAPI.logError((String)"data argument must be DataMap", (Throwable)new IllegalArgumentException());
        }
    }

    public static void checkCraftTweakerVersion(String requiredVersion, IVersionChecker versionChecker) {
        boolean result = versionChecker.getResult();
        if (!result) {
            InvalidCraftTweakerVersionException exception = new InvalidCraftTweakerVersionException(requiredVersion);
            if (FMLCommonHandler.instance().getSide().isServer()) {
                throw exception;
            }
            try {
                Field errorToDisplayField = ReflectUtils.removePrivate(FMLClientHandler.class, "errorToDisplay");
                errorToDisplayField.set(FMLClientHandler.instance(), (Object)exception);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            clazz.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isContentTweakerInstalled() {
        return Loader.isModLoaded((String)"contenttweaker");
    }

    public static boolean onSuppressErrorSingleScriptMode() {
        return suppressErrorSingleScriptMode;
    }

    public static void doSuppressErrorSingleScriptMode() {
        suppressErrorSingleScriptMode = true;
        if (isFirstSetMode) {
            CraftTweakerAPI.logInfo((String)"ZenUtils' suppress error in single script mode is enable.");
            CraftTweakerAPI.logInfo((String)"#ikwid and #nowarn preprocessors of vanilla CraftTweaker are useless now.");
        }
        isFirstSetMode = false;
    }

    private static String getLastZenScriptStack() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            String fileName = stackTraceElement.getFileName();
            if (StringUtils.func_151246_b((String)fileName) || !fileName.endsWith(".zs")) continue;
            return fileName;
        }
        return "";
    }

    @Nonnull
    public static SuppressErrorFlag getCurrentSuppressErrorFlag() {
        return Optional.ofNullable(suppressErrorScriptMap.get(InternalUtils.getLastZenScriptStack())).orElse(SuppressErrorFlag.DEFAULT);
    }

    public static void putSuppressErrorFlag(String zsName, SuppressErrorFlag errorFlag) {
        suppressErrorScriptMap.put(zsName, errorFlag);
    }

    public static Optional<EntityPlayerMP> getPlayer(UUID uuid) {
        return Optional.ofNullable(CraftTweakerAPI.server).map(CraftTweakerMC::getMCServer).map(MinecraftServer::func_184103_al).map(playerList -> playerList.func_177451_a(uuid));
    }

    public static void scanAllEventLists() throws NoSuchFieldException {
        try {
            ALL_EVENT_LISTS.addAll(ReflectUtils.getAllFieldsWithClass(MTEventManager.class, EventList.class, CraftTweakerAPI.events));
        }
        catch (IllegalAccessException e) {
            ZenUtils.forgeLogger.error("Failed to get vanilla CraftTweaker Event List!", (Throwable)e);
        }
        Field membersField = ReflectUtils.removePrivate(TypeExpansion.class, "members");
        Field methodsField = ReflectUtils.removePrivate(ZenExpandMember.class, "methods");
        TypeExpansion eventMangerExpansion = (TypeExpansion)GlobalRegistry.getExpansions().get("crafttweaker.events.IEventManager");
        if (eventMangerExpansion == null) {
            return;
        }
        try {
            Map expandMembers = (Map)membersField.get(eventMangerExpansion);
            ArrayList<Class> lookupClasses = new ArrayList<Class>();
            for (ZenExpandMember expandMember : expandMembers.values()) {
                Class owner;
                Object javaMethod;
                Class<JavaMethod> javaMethodClass;
                List list = (List)methodsField.get(expandMember);
                if (list.isEmpty() || !(javaMethodClass = JavaMethod.class).isInstance(javaMethod = list.get(0)) || lookupClasses.contains(owner = ((JavaMethod)javaMethodClass.cast(javaMethod)).getOwner())) continue;
                lookupClasses.add(owner);
                ALL_EVENT_LISTS.addAll(ReflectUtils.getAllFieldsWithClass(owner, EventList.class, null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
            ZenUtils.forgeLogger.error("Failed to get event manager expansions.", (Throwable)e);
        }
    }

    public static List<EventList> getAllEventLists() {
        return ImmutableList.copyOf(ALL_EVENT_LISTS);
    }
}

