/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import com.google.common.base.Suppliers;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.runtime.ScriptLoader;
import java.util.function.Supplier;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import stanhebben.zenscript.ZenModule;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.reload.ScriptReloadEvent;

public class ReloadCommand
extends CraftTweakerCommand {
    private static final String SCRIPT_LOADER_NAME = "reloadable";
    public static final Supplier<ScriptLoader> RELOADABLE_LOADER = Suppliers.memoize(() -> {
        ScriptLoader loader = CraftTweakerAPI.tweaker.getOrCreateLoader(new String[]{SCRIPT_LOADER_NAME});
        loader.setMainName(SCRIPT_LOADER_NAME);
        loader.addAliases(new String[]{"reloadableevents"});
        return loader;
    });

    public ReloadCommand() {
        super("reload");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)(TextFormatting.DARK_GREEN + "/ct reload"), (String)"/ct reload", (boolean)true), SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_AQUA + "Reload reloadable scripts"))});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (server.func_71262_S()) {
            sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_RED + "The command only can be run in integrated server (SinglePlayer)!")));
            return;
        }
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.AQUA + "Beginning reload scripts")));
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)("Only scripts that marked " + TextFormatting.GRAY + "#loader reloadable " + TextFormatting.RESET + "can be reloaded.")));
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.YELLOW + "Most recipe modifications are not reloadable, they will be ignored.")));
        ZenUtils.tweaker.freezeActionApplying();
        ZenModule.loadedClasses.clear();
        ZenUtils.crafttweakerLogger.clear();
        MinecraftForge.EVENT_BUS.post((Event)new ScriptReloadEvent.Pre(sender));
        ScriptLoader loader = RELOADABLE_LOADER.get();
        loader.setLoaderStage(ScriptLoader.LoaderStage.NOT_LOADED);
        CraftTweakerAPI.tweaker.loadScript(false, loader);
        if (loader.getLoaderStage() == ScriptLoader.LoaderStage.ERROR) {
            sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_RED + "Failed to reload scripts")));
        } else {
            sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)"Reloaded successfully"));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ScriptReloadEvent.Post(sender));
    }
}

