/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.player.MCPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import youyihj.zenutils.api.network.IByteBuf;
import youyihj.zenutils.api.network.IByteBufWriter;
import youyihj.zenutils.impl.network.ZenUtilsByteBuf;
import youyihj.zenutils.impl.network.ZenUtilsNetworkHandler;
import youyihj.zenutils.impl.util.LogMTErrorRunnableWrapper;

public abstract class ZenUtilsMessage
implements IMessage {
    protected int key = 0;
    private IByteBuf byteBuf;
    private IByteBufWriter byteBufWriter;

    public void setKey(String key) {
        this.key = key.hashCode();
    }

    public final void fromBytes(ByteBuf buf) {
        this.key = buf.readInt();
        this.byteBuf = new ZenUtilsByteBuf(buf.copy());
        this.readExtraBytes(this.byteBuf);
    }

    public final void toBytes(ByteBuf buf) {
        this.byteBuf = new ZenUtilsByteBuf(buf);
        this.byteBuf.writeInt(this.key);
        this.writeExtraBytes(this.byteBuf);
    }

    public final IByteBufWriter getByteBufWriter() {
        return this.byteBufWriter;
    }

    public final void setByteBufWriter(IByteBufWriter byteBufWriter) {
        this.byteBufWriter = byteBufWriter;
    }

    protected abstract void writeExtraBytes(IByteBuf var1);

    protected abstract void readExtraBytes(IByteBuf var1);

    public IByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public static class Client2Server
    extends ZenUtilsMessage
    implements IMessageHandler<Client2Server, IMessage> {
        @Override
        protected void readExtraBytes(IByteBuf buf) {
        }

        @Override
        protected void writeExtraBytes(IByteBuf buf) {
            this.getByteBufWriter().write(buf);
        }

        public IMessage onMessage(Client2Server message, MessageContext ctx) {
            IByteBuf byteBuf = message.getByteBuf();
            CraftTweaker.server.func_152344_a((Runnable)LogMTErrorRunnableWrapper.create(() -> ZenUtilsNetworkHandler.INSTANCE.getServerMessageHandler(message.key).handle(CraftTweakerAPI.server, byteBuf, (IPlayer)new MCPlayer((EntityPlayer)ctx.getServerHandler().field_147369_b))));
            return null;
        }
    }

    public static class Server2Client
    extends ZenUtilsMessage
    implements IMessageHandler<Server2Client, IMessage> {
        @Override
        protected void writeExtraBytes(IByteBuf buf) {
            this.getByteBufWriter().write(buf);
        }

        @Override
        protected void readExtraBytes(IByteBuf buf) {
        }

        public IMessage onMessage(Server2Client message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a((Runnable)LogMTErrorRunnableWrapper.create(() -> ZenUtilsNetworkHandler.INSTANCE.getClientMessageHandler(message.key).handle(CraftTweakerAPI.client.getPlayer(), message.getByteBuf())));
            return null;
        }
    }
}

