/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import crafttweaker.api.data.DataBool;
import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataByteArray;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import youyihj.zenutils.api.network.IByteBuf;

public class ByteAndDataConverter {
    private static final Map<Class<? extends IData>, IDataWriter<?>> WRITERS = new HashMap();
    private static final Byte2ObjectArrayMap<IDataReader<?>> READERS = new Byte2ObjectArrayMap();
    private static final Map<Class<? extends IData>, Byte> CLASS_BYTE_MAP = new HashMap<Class<? extends IData>, Byte>();
    private static final byte NULL_DATA_ID = 15;

    public static void writeDataToBytes(IByteBuf byteBuf, @Nullable IData data) {
        IDataWriter<Object> dataWriter;
        if (data == null) {
            dataWriter = IDataWriter.EMPTY;
        } else {
            dataWriter = WRITERS.get(data.getClass());
            byteBuf.writeByte(CLASS_BYTE_MAP.get(data.getClass()));
        }
        dataWriter.write(byteBuf, data);
    }

    @Nullable
    public static IData readDataFromBytes(IByteBuf byteBuf) {
        byte id = byteBuf.readByte();
        return ((IDataReader)READERS.get(id)).read(byteBuf);
    }

    private static <T extends IData> void addWriter(Class<T> type, IDataWriter<T> writer) {
        WRITERS.put(type, writer);
    }

    private static <T extends IData> void addReader(int id, Class<T> type, IDataReader<T> reader) {
        READERS.put((byte)id, reader);
        CLASS_BYTE_MAP.put(type, (byte)id);
    }

    private static void writeBool(IByteBuf byteBuf, DataBool bool) {
        byteBuf.writeByte(bool.asByte());
    }

    private static DataBool readBool(IByteBuf byteBuf) {
        return new DataBool(byteBuf.readByte() == 1);
    }

    private static void writeByte(IByteBuf byteBuf, DataByte dataByte) {
        byteBuf.writeByte(dataByte.asByte());
    }

    private static DataByte readByte(IByteBuf byteBuf) {
        return new DataByte(byteBuf.readByte());
    }

    private static void writeByteArray(IByteBuf byteBuf, DataByteArray byteArray) {
        byte[] bytes = byteArray.asByteArray();
        byteBuf.writeInt(bytes.length);
        byteBuf.getInternal().writeBytes(bytes);
    }

    private static DataByteArray readByteArray(IByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readInt()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = byteBuf.readByte();
        }
        return new DataByteArray(bytes, true);
    }

    private static void writeDouble(IByteBuf byteBuf, DataDouble dataDouble) {
        byteBuf.writeDouble(dataDouble.asDouble());
    }

    private static DataDouble readDouble(IByteBuf byteBuf) {
        return new DataDouble(byteBuf.readDouble());
    }

    private static void writeFloat(IByteBuf byteBuf, DataFloat dataFloat) {
        byteBuf.writeFloat(dataFloat.asFloat());
    }

    private static DataFloat readFloat(IByteBuf byteBuf) {
        return new DataFloat(byteBuf.readFloat());
    }

    private static void writeInt(IByteBuf byteBuf, DataInt dataInt) {
        byteBuf.writeInt(dataInt.asInt());
    }

    private static DataInt readInt(IByteBuf byteBuf) {
        return new DataInt(byteBuf.readInt());
    }

    private static void writeIntArray(IByteBuf byteBuf, DataIntArray intArray) {
        int[] ints = intArray.asIntArray();
        byteBuf.writeInt(ints.length);
        for (int i : ints) {
            byteBuf.writeInt(i);
        }
    }

    private static DataIntArray readIntArray(IByteBuf byteBuf) {
        int[] ints = new int[byteBuf.readInt()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = byteBuf.readInt();
        }
        return new DataIntArray(ints, true);
    }

    private static void writeList(IByteBuf byteBuf, DataList dataList) {
        List list = dataList.asList();
        byteBuf.writeInt(list.size());
        list.forEach(byteBuf::writeData);
    }

    private static DataList readList(IByteBuf byteBuf) {
        return new DataList(Stream.generate(byteBuf::readData).limit(byteBuf.readInt()).collect(Collectors.toList()), true);
    }

    private static void writeLong(IByteBuf byteBuf, DataLong dataLong) {
        byteBuf.writeLong(dataLong.asLong());
    }

    private static DataLong readLong(IByteBuf byteBuf) {
        return new DataLong(byteBuf.readLong());
    }

    private static void writeShort(IByteBuf byteBuf, DataShort dataShort) {
        byteBuf.getInternal().writeShort((int)dataShort.asShort());
    }

    private static DataShort readShort(IByteBuf byteBuf) {
        return new DataShort(byteBuf.getInternal().readShort());
    }

    private static void writeString(IByteBuf byteBuf, DataString dataString) {
        byteBuf.writeString(dataString.asString());
    }

    private static DataString readString(IByteBuf byteBuf) {
        return new DataString(byteBuf.readString());
    }

    private static void writeMap(IByteBuf byteBuf, DataMap dataMap) {
        Map stringIDataMap = dataMap.asMap();
        byteBuf.writeInt(stringIDataMap.size());
        stringIDataMap.forEach((key, value) -> {
            byteBuf.writeString((String)key);
            byteBuf.writeData((IData)value);
        });
    }

    private static DataMap readMap(IByteBuf byteBuf) {
        HashMap<String, IData> temp = new HashMap<String, IData>();
        int bound = byteBuf.readInt();
        for (int i = 0; i < bound; ++i) {
            temp.put(byteBuf.readString(), byteBuf.readData());
        }
        return new DataMap(temp, true);
    }

    static {
        ByteAndDataConverter.addWriter(DataBool.class, ByteAndDataConverter::writeBool);
        ByteAndDataConverter.addReader(0, DataBool.class, ByteAndDataConverter::readBool);
        ByteAndDataConverter.addWriter(DataByte.class, ByteAndDataConverter::writeByte);
        ByteAndDataConverter.addReader(1, DataByte.class, ByteAndDataConverter::readByte);
        ByteAndDataConverter.addWriter(DataByteArray.class, ByteAndDataConverter::writeByteArray);
        ByteAndDataConverter.addReader(2, DataByteArray.class, ByteAndDataConverter::readByteArray);
        ByteAndDataConverter.addWriter(DataDouble.class, ByteAndDataConverter::writeDouble);
        ByteAndDataConverter.addReader(3, DataDouble.class, ByteAndDataConverter::readDouble);
        ByteAndDataConverter.addWriter(DataFloat.class, ByteAndDataConverter::writeFloat);
        ByteAndDataConverter.addReader(4, DataFloat.class, ByteAndDataConverter::readFloat);
        ByteAndDataConverter.addWriter(DataInt.class, ByteAndDataConverter::writeInt);
        ByteAndDataConverter.addReader(5, DataInt.class, ByteAndDataConverter::readInt);
        ByteAndDataConverter.addWriter(DataIntArray.class, ByteAndDataConverter::writeIntArray);
        ByteAndDataConverter.addReader(6, DataIntArray.class, ByteAndDataConverter::readIntArray);
        ByteAndDataConverter.addWriter(DataList.class, ByteAndDataConverter::writeList);
        ByteAndDataConverter.addReader(7, DataList.class, ByteAndDataConverter::readList);
        ByteAndDataConverter.addWriter(DataLong.class, ByteAndDataConverter::writeLong);
        ByteAndDataConverter.addReader(8, DataLong.class, ByteAndDataConverter::readLong);
        ByteAndDataConverter.addWriter(DataShort.class, ByteAndDataConverter::writeShort);
        ByteAndDataConverter.addReader(9, DataShort.class, ByteAndDataConverter::readShort);
        ByteAndDataConverter.addWriter(DataString.class, ByteAndDataConverter::writeString);
        ByteAndDataConverter.addReader(10, DataString.class, ByteAndDataConverter::readString);
        ByteAndDataConverter.addWriter(DataMap.class, ByteAndDataConverter::writeMap);
        ByteAndDataConverter.addReader(11, DataMap.class, ByteAndDataConverter::readMap);
        ByteAndDataConverter.addWriter(IData.class, IDataWriter.EMPTY);
        ByteAndDataConverter.addReader(15, IData.class, IDataReader.EMPTY);
    }

    @FunctionalInterface
    private static interface IDataReader<T extends IData> {
        public static final IDataReader<IData> EMPTY = byteBuf -> null;

        public T read(IByteBuf var1);
    }

    @FunctionalInterface
    private static interface IDataWriter<T extends IData> {
        public static final IDataWriter<IData> EMPTY = (byteBuf, data) -> byteBuf.writeByte((byte)15);

        public void write(IByteBuf var1, T var2);
    }
}

