/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.delegate;

import crafttweaker.IAction;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.ITweaker;
import crafttweaker.runtime.ScriptLoader;
import crafttweaker.runtime.events.CrTLoaderLoadingEvent;
import crafttweaker.runtime.events.CrTScriptLoadingEvent;
import crafttweaker.util.IEventHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.reload.Reloadable;

public class ZenUtilsTweaker
implements ITweaker {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private final ITweaker tweaker;
    private boolean freeze = false;
    private final Queue<IAction> reloadableActions = new LinkedList<IAction>();
    private final Map<Class<?>, Boolean> actionReloadableCheck = new HashMap();
    private final Map<Class<?>, Optional<MethodHandle>> undoMethods = new HashMap();

    public ZenUtilsTweaker(ITweaker tweaker) {
        this.tweaker = tweaker;
    }

    public void apply(IAction action) {
        boolean reloadable = this.isReloadable(action);
        if (!this.freeze || reloadable) {
            this.tweaker.apply(action);
        }
        if (reloadable && this.getUndoMethod(action).isPresent()) {
            this.reloadableActions.add(action);
        }
    }

    public void setScriptProvider(IScriptProvider provider) {
        this.tweaker.setScriptProvider(provider);
    }

    public void load() {
        this.tweaker.load();
    }

    public boolean loadScript(boolean isSyntaxCommand, String loaderName) {
        return this.tweaker.loadScript(isSyntaxCommand, loaderName);
    }

    public void loadScript(boolean isSyntaxCommand, ScriptLoader loader) {
        this.tweaker.loadScript(isSyntaxCommand, loader);
    }

    public List<IAction> getActions() {
        return this.tweaker.getActions();
    }

    public void enableDebug() {
        this.tweaker.enableDebug();
    }

    public PreprocessorManager getPreprocessorManager() {
        return this.tweaker.getPreprocessorManager();
    }

    public NetworkSide getNetworkSide() {
        return this.tweaker.getNetworkSide();
    }

    public void setNetworkSide(NetworkSide networkSide) {
        this.tweaker.setNetworkSide(networkSide);
    }

    public void registerLoadStartedEvent(IEventHandler<CrTLoaderLoadingEvent.Started> eventHandler) {
        this.tweaker.registerLoadStartedEvent(eventHandler);
    }

    public void registerLoadFinishedEvent(IEventHandler<CrTLoaderLoadingEvent.Finished> eventHandler) {
        this.tweaker.registerLoadFinishedEvent(eventHandler);
    }

    public void registerLoadAbortedEvent(IEventHandler<CrTLoaderLoadingEvent.Aborted> eventHandler) {
        this.tweaker.registerLoadAbortedEvent(eventHandler);
    }

    public void registerScriptLoadPreEvent(IEventHandler<CrTScriptLoadingEvent.Pre> eventHandler) {
        this.tweaker.registerScriptLoadPreEvent(eventHandler);
    }

    public void registerScriptLoadPostEvent(IEventHandler<CrTScriptLoadingEvent.Post> eventHandler) {
        this.tweaker.registerScriptLoadPostEvent(eventHandler);
    }

    public List<ScriptLoader> getLoaders() {
        return this.tweaker.getLoaders();
    }

    public ScriptLoader getOrCreateLoader(String ... nameAndAliases) {
        return this.tweaker.getOrCreateLoader(nameAndAliases);
    }

    public void freezeActionApplying() {
        this.freeze = true;
    }

    public ITweaker getITweaker() {
        return this.tweaker;
    }

    public void onReload() {
        while (!this.reloadableActions.isEmpty()) {
            IAction action = this.reloadableActions.poll();
            this.getUndoMethod(action).ifPresent(methodHandle -> {
                try {
                    methodHandle.invoke(action);
                }
                catch (Throwable e) {
                    ZenUtils.forgeLogger.error("Failed to invoke undo method", e);
                }
            });
        }
    }

    public Queue<IAction> getReloadableActions() {
        return this.reloadableActions;
    }

    private boolean isReloadable(IAction action) {
        return this.actionReloadableCheck.computeIfAbsent(action.getClass(), clazz -> clazz.isAnnotationPresent(Reloadable.class));
    }

    private Optional<MethodHandle> getUndoMethod(IAction action) {
        return this.undoMethods.computeIfAbsent(action.getClass(), clazz -> {
            try {
                return Optional.of(LOOKUP.findVirtual((Class<?>)clazz, "undo", MethodType.methodType(Void.TYPE)));
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        });
    }
}

