/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.delegate;

import crafttweaker.api.logger.MTLogger;
import crafttweaker.api.player.IPlayer;
import crafttweaker.runtime.ILogger;
import crafttweaker.util.SuppressErrorFlag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.util.ReflectUtils;
import youyihj.zenutils.impl.util.ScriptRunException;

public class ZenUtilsLogger
extends MTLogger
implements ILogger {
    private final MTLogger mtLogger;
    private static Field mtLoggersField;
    private boolean hasError = false;
    private final List<String> messagesToSendPlayer = new ArrayList<String>();
    private final List<IPlayer> playerList = new ArrayList<IPlayer>();
    private final Set<Pattern> filterLogRegexes = new TreeSet<Pattern>(Comparator.comparing(Pattern::toString));

    public ZenUtilsLogger(MTLogger mtLogger) {
        this.mtLogger = mtLogger;
    }

    public void addLogger(ILogger logger) {
        this.mtLogger.addLogger(logger);
    }

    public void removeLogger(ILogger logger) {
        this.mtLogger.removeLogger(logger);
    }

    public void addPlayer(IPlayer player) {
        if (InternalUtils.onSuppressErrorSingleScriptMode()) {
            this.playerList.add(player);
            this.logPlayer(player);
        } else {
            this.mtLogger.addPlayer(player);
        }
    }

    public void removePlayer(IPlayer player) {
        if (InternalUtils.onSuppressErrorSingleScriptMode()) {
            this.playerList.remove(player);
        } else {
            this.mtLogger.removePlayer(player);
        }
    }

    public void clear() {
        this.mtLogger.clear();
        this.messagesToSendPlayer.clear();
    }

    public void logCommand(String message) {
        if (this.shouldNotLog(message)) {
            return;
        }
        this.mtLogger.logCommand(message);
    }

    public void logInfo(String message) {
        if (this.shouldNotLog(message)) {
            return;
        }
        this.mtLogger.logInfo(message);
    }

    public void logWarning(String message) {
        if (this.shouldNotLog(message)) {
            return;
        }
        if (InternalUtils.onSuppressErrorSingleScriptMode()) {
            this.getLoggers().forEach(logger -> logger.logWarning(message));
            SuppressErrorFlag errorFlag = InternalUtils.getCurrentSuppressErrorFlag();
            if (errorFlag.isSuppressingWarnings()) {
                return;
            }
            String message2 = "\u00a7eWARNING: " + message;
            if (this.playerList.isEmpty()) {
                this.messagesToSendPlayer.add(message2);
            } else {
                this.playerList.forEach(player -> player.sendChat(message2));
            }
        } else {
            this.mtLogger.logWarning(message);
        }
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable exception) {
        if (this.shouldNotLog(message)) {
            return;
        }
        if (InternalUtils.onSuppressErrorSingleScriptMode()) {
            this.getLoggers().forEach(logger -> logger.logError(message, exception));
            SuppressErrorFlag errorFlag = InternalUtils.getCurrentSuppressErrorFlag();
            if (errorFlag.isSuppressingErrors()) {
                return;
            }
            if (InternalUtils.hardFailMode) {
                if (exception == null) {
                    throw new ScriptRunException(message);
                }
                if (exception instanceof ScriptRunException) {
                    throw (ScriptRunException)exception;
                }
                throw new ScriptRunException(message, exception);
            }
            String message2 = "\u00a7cERROR: " + super.getMessageToSendPlayer(message, exception);
            this.hasError = true;
            if (this.playerList.isEmpty()) {
                this.messagesToSendPlayer.add(message2);
            } else {
                this.playerList.forEach(player -> player.sendChat(message2));
            }
        } else {
            this.mtLogger.logError(message, exception);
        }
    }

    public void logPlayer(IPlayer player) {
        this.messagesToSendPlayer.forEach(arg_0 -> ((IPlayer)player).sendChat(arg_0));
    }

    public void logDefault(String message) {
        if (this.shouldNotLog(message)) {
            return;
        }
        this.mtLogger.logDefault(message);
    }

    public boolean isLogDisabled() {
        return this.mtLogger.isLogDisabled();
    }

    public void setLogDisabled(boolean logDisabled) {
        this.mtLogger.setLogDisabled(logDisabled);
    }

    private List<ILogger> getLoggers() {
        try {
            return (List)mtLoggersField.get(this.mtLogger);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public void addRegexLogFilter(String regex) {
        this.filterLogRegexes.add(Pattern.compile(regex));
    }

    private boolean shouldNotLog(String message) {
        if (message == null) {
            return false;
        }
        return this.filterLogRegexes.stream().anyMatch(pattern -> pattern.matcher(message).matches());
    }

    public boolean hasError() {
        return this.hasError;
    }

    static {
        try {
            Class<MTLogger> clazz = MTLogger.class;
            mtLoggersField = ReflectUtils.removePrivateFinal(clazz, "loggers");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

