/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.world;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.entity.MCEntityItem;
import crafttweaker.mc1120.player.MCPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.item.CrTItemHandler;
import youyihj.zenutils.api.liquid.CrTLiquidHandler;
import youyihj.zenutils.api.util.CrTUUID;
import youyihj.zenutils.api.util.catenation.ICatenationBuilder;
import youyihj.zenutils.impl.capability.IZenWorldCapability;
import youyihj.zenutils.impl.capability.ZenWorldCapabilityHandler;
import youyihj.zenutils.impl.util.catenation.CatenationBuilder;

@ZenRegister
@ZenClass(value="mods.zenutils.ZenUtilsWorld")
@ZenExpansion(value="crafttweaker.world.IWorld")
public class ZenUtilsWorld {
    @Nullable
    @ZenMethod
    public static IPlayer getPlayerByName(IWorld iWorld, String name) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_72924_a(name));
    }

    @Nullable
    @ZenMethod
    public static IPlayer getPlayerByUUID(IWorld iWorld, CrTUUID uuid) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_152378_a(uuid.getInternal()));
    }

    @ZenMethod
    public static List<IPlayer> getAllPlayers(IWorld iWorld) {
        ArrayList temp = Lists.newArrayList();
        temp.addAll(CraftTweakerMC.getWorld((IWorld)iWorld).field_73010_i.stream().map(MCPlayer::new).collect(Collectors.toList()));
        return temp;
    }

    @ZenMethod
    public static IPlayer getClosestPlayerToEntity(IWorld iWorld, IEntity iEntity, double distance, boolean spectator) {
        return ZenUtilsWorld.getClosestPlayer(iWorld, iEntity.getPosX(), iEntity.getPosY(), iEntity.getPosZ(), distance, spectator);
    }

    @ZenMethod
    public static IPlayer getClosestPlayer(IWorld iWorld, double posX, double posY, double posZ, double distance, boolean spectator) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_184137_a(posX, posY, posZ, distance, spectator));
    }

    @ZenMethod
    public static List<IEntity> getEntities(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).field_72996_f.stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
    }

    @ZenMethod
    public static List<IEntityItem> getEntityItems(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).func_175644_a(EntityItem.class, entity -> true).stream().map(MCEntityItem::new).collect(Collectors.toList());
    }

    @ZenMethod
    public static List<IPlayer> getPlayers(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).field_73010_i.stream().map(MCPlayer::new).collect(Collectors.toList());
    }

    @ZenMethod
    public static IData getCustomWorldData(IWorld world) {
        return ZenUtilsWorld.getWorldCap(world).getData();
    }

    @ZenMethod
    public static void setCustomWorldData(IWorld world, IData data) {
        ZenUtilsWorld.getWorldCap(world).setData(data);
    }

    @ZenMethod
    public static void updateCustomWorldData(IWorld world, IData data) {
        ZenUtilsWorld.getWorldCap(world).updateData(data);
    }

    @ZenMethod
    public static IData getCustomChunkData(IWorld world, IBlockPos posToGetChunk) {
        return ZenUtilsWorld.getChunkCap(world, posToGetChunk).getData();
    }

    @ZenMethod
    public static void setCustomChunkData(IWorld world, IData data, IBlockPos posToGetChunk) {
        ZenUtilsWorld.getChunkCap(world, posToGetChunk).setData(data);
        ZenUtilsWorld.getChunk(world, posToGetChunk).func_76630_e();
    }

    @ZenMethod
    public static void updateCustomChunkData(IWorld world, IData data, IBlockPos posToGetChunk) {
        ZenUtilsWorld.getChunkCap(world, posToGetChunk).updateData(data);
        ZenUtilsWorld.getChunk(world, posToGetChunk).func_76630_e();
    }

    @ZenMethod
    public static void destroyBlock(IWorld world, IBlockPos pos, boolean dropBlock) {
        CraftTweakerMC.getWorld((IWorld)world).func_175655_b(CraftTweakerMC.getBlockPos((IBlockPos)pos), dropBlock);
    }

    @ZenMethod
    public static CrTItemHandler getItemHandler(IWorld world, IBlockPos pos, @Optional IFacing facing) {
        return java.util.Optional.ofNullable(CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos))).map(tileEntity -> {
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, CraftTweakerMC.getFacing((IFacing)facing));
            return CrTItemHandler.of(itemHandler);
        }).orElse(null);
    }

    @ZenMethod
    public static CrTLiquidHandler getLiquidHandler(IWorld world, IBlockPos pos, @Optional IFacing facing) {
        return java.util.Optional.ofNullable(CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos))).map(tileEntity -> {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, CraftTweakerMC.getFacing((IFacing)facing));
            return CrTLiquidHandler.of(fluidHandler);
        }).orElse(null);
    }

    @ZenMethod
    public static ICatenationBuilder catenation(IWorld world) {
        return new CatenationBuilder(world);
    }

    private static IZenWorldCapability getWorldCap(IWorld world) {
        return (IZenWorldCapability)CraftTweakerMC.getWorld((IWorld)world).getCapability(ZenWorldCapabilityHandler.ZEN_WORLD_CAPABILITY, null);
    }

    private static IZenWorldCapability getChunkCap(IWorld world, IBlockPos posToGetChunk) {
        return (IZenWorldCapability)ZenUtilsWorld.getChunk(world, posToGetChunk).getCapability(ZenWorldCapabilityHandler.ZEN_WORLD_CAPABILITY, null);
    }

    private static Chunk getChunk(IWorld world, IBlockPos pos) {
        return CraftTweakerMC.getWorld((IWorld)world).func_175726_f(CraftTweakerMC.getBlockPos((IBlockPos)pos));
    }
}

