/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import youyihj.zenutils.api.cotx.annotation.ExpandContentTweakerEntry;
import youyihj.zenutils.api.cotx.item.EnergyItemRepresentation;
import youyihj.zenutils.api.cotx.item.ExpandItemContent;

@ExpandContentTweakerEntry
public class EnergyItemContent
extends ExpandItemContent
implements IEnergyContainerItem {
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;
    private final EnergyItemRepresentation energyItemRepresentation;

    public EnergyItemContent(EnergyItemRepresentation itemRepresentation) {
        super(itemRepresentation);
        this.capacity = itemRepresentation.capacity;
        this.maxReceive = itemRepresentation.maxReceive;
        this.maxExtract = itemRepresentation.maxExtract;
        this.field_77777_bU = 1;
        this.energyItemRepresentation = itemRepresentation;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.canReceive()) {
            int received = Math.min(this.capacity - this.getEnergyStored(container), Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.setEnergyStored(container, this.getEnergyStored(container) + received);
            }
            return received;
        }
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.canExtract()) {
            int extracted = Math.min(this.getEnergyStored(container), Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                this.setEnergyStored(container, this.getEnergyStored(container) - extracted);
            }
            return extracted;
        }
        return 0;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77942_o() && container.func_77978_p().func_74764_b("energy")) {
            return container.func_77978_p().func_74762_e("energy");
        }
        this.setEnergyStored(container, 0);
        return 0;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public void setEnergyStored(ItemStack container, int energy) {
        if (container.func_77942_o()) {
            container.func_77978_p().func_74768_a("energy", energy);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("energy", energy);
            container.func_77982_d(nbt);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.zenutils.energy", (Object[])new Object[]{this.getEnergyStored(stack), this.getMaxEnergyStored(stack)}));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    @ExpandContentTweakerEntry.RepresentationGetter
    public EnergyItemRepresentation getEnergyItemRepresentation() {
        return this.energyItemRepresentation;
    }
}

