/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.preprocessor.PreprocessorManager;
import java.lang.reflect.Field;
import net.minecraft.command.CommandHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Logger;
import stanhebben.zenscript.symbols.IZenSymbol;
import youyihj.zenutils.api.command.ZenCommandRegisterAction;
import youyihj.zenutils.api.cotx.brackets.LateGetContentLookup;
import youyihj.zenutils.api.ftbq.FTBQEventManager;
import youyihj.zenutils.api.preprocessor.HardFailPreprocessor;
import youyihj.zenutils.api.preprocessor.NoFixRecipeBookPreprocessor;
import youyihj.zenutils.api.preprocessor.SuppressErrorPreprocessor;
import youyihj.zenutils.api.util.ZenUtilsGlobal;
import youyihj.zenutils.impl.capability.ZenWorldCapabilityHandler;
import youyihj.zenutils.impl.delegate.ZenUtilsLogger;
import youyihj.zenutils.impl.delegate.ZenUtilsTweaker;
import youyihj.zenutils.impl.reload.ReloadCommand;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.util.ReflectUtils;

@Mod(modid="zenutils", name="ZenUtils", version="1.12.2", dependencies="required-after:crafttweaker;after:contenttweaker;required-after:redstoneflux;after:ftbquests", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ZenUtils {
    public static final String MODID = "zenutils";
    public static final String NAME = "ZenUtils";
    public static final String VERSION = "1.12.2";
    public static final String DEPENDENCIES = "required-after:crafttweaker;after:contenttweaker;required-after:redstoneflux;after:ftbquests";
    public static Logger forgeLogger;
    public static ZenUtilsLogger crafttweakerLogger;
    public static ZenUtilsTweaker tweaker;

    @Mod.EventHandler
    public static void onConstruct(FMLConstructionEvent event) {
        InternalUtils.checkCraftTweakerVersion("4.1.20.673", () -> InternalUtils.hasMethod(CraftTweakerMC.class, "getIItemStackForMatching", ItemStack.class));
        CraftTweakerAPI.registerGlobalSymbol((String)"typeof", (IZenSymbol)CraftTweakerAPI.getJavaStaticMethodSymbol(ZenUtilsGlobal.class, (String)"typeof", (Class[])new Class[]{Object.class}));
        CraftTweakerAPI.registerGlobalSymbol((String)"toString", (IZenSymbol)CraftTweakerAPI.getJavaStaticMethodSymbol(ZenUtilsGlobal.class, (String)"toString", (Class[])new Class[]{Object.class}));
        CraftTweakerAPI.registerGlobalSymbol((String)"addRegexLogFilter", (IZenSymbol)CraftTweakerAPI.getJavaStaticMethodSymbol(ZenUtilsGlobal.class, (String)"addRegexLogFilter", (Class[])new Class[]{String.class}));
        PreprocessorManager preprocessorManager = CraftTweakerAPI.tweaker.getPreprocessorManager();
        preprocessorManager.registerPreprocessorAction("suppress", SuppressErrorPreprocessor::new);
        preprocessorManager.registerPreprocessorAction("no_fix_recipe_book", NoFixRecipeBookPreprocessor::new);
        preprocessorManager.registerPreprocessorAction("hardfail", HardFailPreprocessor::new);
        try {
            crafttweakerLogger = new ZenUtilsLogger(CrafttweakerImplementationAPI.logger);
            Field loggerField = ReflectUtils.removePrivateFinal(CrafttweakerImplementationAPI.class, "logger");
            loggerField.set(null, (Object)crafttweakerLogger);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CraftTweakerAPI.logInfo((String)"Fail to set crafttweaker logger to zenutils one. #suppress preprocessor cannot work properly.");
            e.printStackTrace();
        }
        try {
            tweaker = new ZenUtilsTweaker(CraftTweakerAPI.tweaker);
            Field tweakerField = ReflectUtils.removePrivateFinal(CraftTweakerAPI.class, "tweaker");
            tweakerField.set(null, tweaker);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CraftTweakerAPI.logWarning((String)"Fail to set crafttweaker tweaker");
            e.printStackTrace();
        }
        if (Loader.isModLoaded((String)"ftbquests")) {
            MinecraftForge.EVENT_BUS.register(FTBQEventManager.Handler.class);
        }
    }

    @Mod.EventHandler
    public static void onPreInit(FMLPreInitializationEvent event) {
        ZenWorldCapabilityHandler.register();
        forgeLogger = event.getModLog();
        try {
            InternalUtils.scanAllEventLists();
        }
        catch (NoSuchFieldException e) {
            forgeLogger.error("failed to scan all event lists", (Throwable)e);
        }
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        CTChatCommand.registerCommand((CraftTweakerCommand)new ReloadCommand());
        ZenCommandRegisterAction.ApplyLogic.INSTANCE.init((CommandHandler)event.getServer().field_71321_q);
        if (InternalUtils.isContentTweakerInstalled()) {
            LateGetContentLookup.refreshFields();
            LateGetContentLookup.clear();
        }
    }

    @Mod.EventHandler
    public static void onServerStop(FMLServerStoppedEvent event) {
        ZenCommandRegisterAction.ApplyLogic.INSTANCE.clean();
    }

    @Mod.EventHandler
    public static void onServerStarted(FMLServerStartedEvent event) {
        CraftTweakerAPI.tweaker.getActions().clear();
    }
}

