/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.client.handler.IGuiProvider;
import com.valkyrieofnight.vlib.core.client.handler.IGuiTrigger;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VLGuiHandler
implements IGuiHandler {
    private Map<IGuiTrigger, Integer> gti = Maps.newHashMap();
    private Map<Integer, IGuiTrigger> itg = Maps.newHashMap();
    private int nextID = 0;
    @SideOnly(value=Side.CLIENT)
    private GuiScreen lastScreen;

    public final void register(IGuiTrigger obj) {
        this.gti.put(obj, this.nextID);
        this.itg.put(this.nextID, obj);
        ++this.nextID;
    }

    public int getGuiID(IGuiTrigger obj) {
        return this.gti.containsKey(obj) ? this.gti.get(obj) : 0;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        IGuiProvider provider = this.getGuiProvider(ID, player, world, x, y, z);
        if (provider != null) {
            return provider.getServerGuiElement(player, world);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        this.lastScreen = Minecraft.func_71410_x().field_71462_r;
        IGuiProvider provider = this.getGuiProvider(ID, player, world, x, y, z);
        if (provider != null) {
            return provider.getServerGuiElement(player, world);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void returnToLast() {
        if (this.lastScreen != null) {
            Minecraft.func_71410_x().func_147108_a(this.lastScreen);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setLast(GuiScreen gui) {
        this.lastScreen = gui;
    }

    private IGuiProvider getGuiProvider(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.itg.containsKey(id)) {
            IGuiTrigger trigger = this.itg.get(id);
            switch (trigger.getType()) {
                case TILE: {
                    TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                    if (!(te instanceof IGuiProvider)) break;
                    return (IGuiProvider)te;
                }
                case ITEM: {
                    if (player.func_184614_ca() == ItemStack.field_190927_a) {
                        return null;
                    }
                    Item item = player.func_184614_ca().func_77973_b();
                    if (!(item instanceof IGuiProvider)) break;
                    return (IGuiProvider)item;
                }
                case BLOCK: {
                    IBlockState bs = world.func_180495_p(new BlockPos(x, y, z));
                    Block blk = bs.func_177230_c();
                    if (!(blk instanceof IGuiProvider)) break;
                    return (IGuiProvider)blk;
                }
                case OTHER: {
                    if (!(trigger instanceof IGuiProvider)) break;
                    return (IGuiProvider)((Object)trigger);
                }
            }
        }
        return null;
    }
}

