/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.modifier;

import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import com.valkyrieofnight.um.api.attribute.IAttributeCalculator;
import com.valkyrieofnight.um.api.modifier.IModifier;
import com.valkyrieofnight.um.api.modifier.IModifierHandler;
import com.valkyrieofnight.um.api.modifier.ModifierID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ModifierHandler
implements IModifierHandler {
    private boolean needsUpdate = true;
    protected Map<ModifierID, IModifier> modifiers = new HashMap<ModifierID, IModifier>();
    protected Map<ModifierID, Integer> modifierCount = new HashMap<ModifierID, Integer>();
    protected Map<AttributeID, List<IAttribute>> attributes = new HashMap<AttributeID, List<IAttribute>>();
    protected Map<AttributeID, Object> attributeFinalValues = new HashMap<AttributeID, Object>();

    @Override
    public boolean hasModifier(ModifierID modifierID) {
        return this.modifiers.get(modifierID) != null;
    }

    @Override
    public boolean setModifier(IModifier modifier, int total) {
        if (modifier == null) {
            return false;
        }
        this.modifiers.put(modifier.getModifierID(), modifier);
        this.modifierCount.put(modifier.getModifierID(), total);
        this.needsUpdate = true;
        return true;
    }

    @Override
    public void removeModifier(@Nonnull ModifierID modifierID) {
        this.modifiers.remove(modifierID);
        this.modifierCount.remove(modifierID);
        this.needsUpdate = true;
    }

    @Override
    public void removeModifiersAll() {
        this.modifiers = new HashMap<ModifierID, IModifier>();
        this.modifierCount = new HashMap<ModifierID, Integer>();
        this.attributes = new HashMap<AttributeID, List<IAttribute>>();
        this.attributeFinalValues = new HashMap<AttributeID, Object>();
    }

    @Override
    public int getTotal(ModifierID modifierID) {
        return this.hasModifier(modifierID) ? this.modifierCount.get(modifierID) : 0;
    }

    public void update() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            for (ModifierID modifier : this.modifierCount.keySet()) {
                int count = this.modifierCount.get(modifier);
                IModifier mod = this.modifiers.get(modifier);
                for (IAttribute attribute : mod.getAttributes()) {
                    List<IAttribute> attributesList = this.attributes.get(attribute.getAttributeID());
                    if (attributesList == null) {
                        attributesList = new ArrayList<IAttribute>();
                    }
                    for (int i = 0; i < count; ++i) {
                        attributesList.add(attribute);
                    }
                    this.attributes.put(attribute.getAttributeID(), attributesList);
                }
            }
            for (AttributeID atid : this.attributes.keySet()) {
                IAttributeCalculator calc = atid.getCalculator();
                this.attributeFinalValues.put(atid, calc.calculateFinalValue(this.attributes.get(atid)));
            }
        }
    }

    @Override
    public boolean hasAttribute(@Nonnull AttributeID attributeID) {
        return this.attributes.get(attributeID) != null;
    }

    @Override
    public List<IAttribute> getAttributes(@Nonnull AttributeID attributeID) {
        return this.attributes.get(attributeID);
    }

    @Override
    public Object getAttributeFinalValue(AttributeID attributeID) {
        return this.attributeFinalValues.get(attributeID);
    }
}

