/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.harvest.ToolHelper;

public class ToolOverwrite {
    public final Map<String, Integer> harvest_levels = new HashMap<String, Integer>();

    public String getConfig() {
        StringBuilder res = new StringBuilder();
        String prefix = "";
        for (Map.Entry<String, Integer> entry : this.harvest_levels.entrySet()) {
            res.append(prefix);
            res.append(entry.getKey()).append('=').append(entry.getValue());
            prefix = ",";
        }
        return res.toString();
    }

    public void addOverwrite(String toolclass, int level) {
        this.harvest_levels.put(toolclass, level);
    }

    public void apply(Item item) {
        HashSet toolClasses = new HashSet(item.getToolClasses(new ItemStack(item)));
        for (String string : toolClasses) {
            ToolHelper.setHarvestLevel(item, string, -1);
        }
        for (Map.Entry entry : this.harvest_levels.entrySet()) {
            ToolHelper.setHarvestLevel(item, (String)entry.getKey(), (Integer)entry.getValue());
            ToolProgressionMod.logger.log(Level.INFO, String.format("Applying overwrite to item %s: %s %d", item.getRegistryName(), entry.getKey(), entry.getValue()));
        }
    }
}

