/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemTool;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.config.ConfigHandler;

@SideOnly(value=Side.CLIENT)
public class TooltipEventHandler {
    private static String formatLevel(int level) {
        if (OverwrittenContent.mining_level.containsKey(level)) {
            return OverwrittenContent.mining_level.get(level).getFormatted();
        }
        return String.valueOf(level);
    }

    private static void printForClass(ItemTooltipEvent event, Item item, String tool_class, String postfix) {
        int level = item.getHarvestLevel(event.getItemStack(), tool_class, null, Blocks.field_150348_b.func_176223_P());
        if (level == -1 && item instanceof ItemTool && item.getToolClasses(event.getItemStack()).contains(tool_class)) {
            ItemTool tool = (ItemTool)item;
            level = tool.getHarvestLevel(event.getItemStack(), tool_class, null, Blocks.field_150348_b.func_176223_P());
        }
        if (level == -1) {
            return;
        }
        event.getToolTip().add("\u00a7eMining Level:\u00a7r " + TooltipEventHandler.formatLevel(level) + postfix);
    }

    @SubscribeEvent
    public void onGetToolTipEvent(ItemTooltipEvent event) {
        if (!ConfigHandler.tooltip_enabled) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).func_179223_d();
                IBlockState state = block.func_176203_a(item.getDamage(event.getItemStack()));
                String tool_class = block.getHarvestTool(state);
                int level = block.getHarvestLevel(state);
                event.getToolTip().add("\u00a7eMining Level:\u00a7r " + TooltipEventHandler.formatLevel(level) + "(" + tool_class + ")");
            } else {
                for (String tool_class : item.getToolClasses(event.getItemStack())) {
                    TooltipEventHandler.printForClass(event, item, tool_class, "(" + tool_class + ")");
                }
            }
        } else {
            TooltipEventHandler.printForClass(event, item, "pickaxe", "");
        }
    }
}

