/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.harvest.ToolHelper;
import tyra314.toolprogression.harvest.ToolOverwrite;

public class ToolOverwriteConfig {
    private final Configuration cfg;
    private final Map<ResourceLocation, ToolOverwrite> overwrites = new HashMap<ResourceLocation, ToolOverwrite>();

    ToolOverwriteConfig(Configuration file) {
        this.cfg = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.cfg.load();
            this.cfg.addCustomCategoryComment("tool", "To add any overwrites, simply copy them over from the tools.cfg");
            this.overwrites.clear();
            for (Map.Entry tool : this.cfg.getCategory("tool").entrySet()) {
                ResourceLocation rl = new ResourceLocation((String)tool.getKey());
                ToolOverwrite overwrite = ToolHelper.createFromConfigString(((Property)tool.getValue()).getString());
                this.overwrites.put(rl, overwrite);
            }
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem loading tool overwrites file!", (Throwable)e);
        }
        finally {
            if (this.cfg.hasChanged()) {
                this.cfg.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.cfg.addCustomCategoryComment("tool", "To add any overwrites, simply copy them over from the tools.cfg");
            ConfigCategory tool = this.cfg.getCategory("tool");
            tool.clear();
            for (Map.Entry<ResourceLocation, ToolOverwrite> entry : this.overwrites.entrySet()) {
                tool.put(entry.getKey().toString(), new Property(entry.getKey().toString(), entry.getValue().getConfig(), Property.Type.STRING));
            }
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem saving tool overwrites file!", (Throwable)e);
        }
        finally {
            this.cfg.save();
        }
    }

    public ToolOverwrite get(Item item) {
        if (this.overwrites.containsKey(item.getRegistryName())) {
            return this.overwrites.get(item.getRegistryName());
        }
        return null;
    }

    public void unset(Item item) {
        this.overwrites.remove(item.getRegistryName());
    }

    public void set(Item item, ToolOverwrite overwrite) {
        this.overwrites.put(item.getRegistryName(), overwrite);
    }
}

