/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.command.subcommand;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.command.SubCommand;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.harvest.BlockHelper;
import tyra314.toolprogression.harvest.BlockOverwrite;
import tyra314.toolprogression.harvest.ToolOverwrite;

public class Set
extends SubCommand {
    @Override
    public String getName() {
        return "set";
    }

    @Override
    public boolean handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        EntityPlayer player = (EntityPlayer)server.func_184103_al().func_181057_v().get(0);
        if (args.length < 3) {
            return false;
        }
        String itemclass = args[1];
        int level = Integer.parseInt(args[2]);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Can't set overwrite for an empty item."));
            return true;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemTool) {
            ToolOverwrite overwrite = ConfigHandler.toolOverwrites.get(item);
            if (overwrite == null) {
                overwrite = new ToolOverwrite();
            }
            overwrite.addOverwrite(itemclass, level);
            overwrite.apply(item);
            ConfigHandler.toolOverwrites.set(item, overwrite);
            ConfigHandler.toolOverwrites.save();
            OverwrittenContent.tools.put(item.func_77658_a(), overwrite);
            this.sendMessage(sender, "added the tool overwrite for '" + TextFormatting.BOLD.toString() + stack.func_82833_r() + TextFormatting.RESET.toString() + "' .");
            return true;
        }
        if (item instanceof ItemBlock) {
            ItemBlock iblock = (ItemBlock)item;
            Block block = iblock.func_179223_d();
            IBlockState state = block.func_176203_a(item.getDamage(stack));
            String key = BlockHelper.getKeyString(state);
            BlockOverwrite overwrite = ConfigHandler.blockOverwrites.get(key);
            if (overwrite == null) {
                overwrite = new BlockOverwrite(itemclass, level, true, BlockOverwrite.OverwriteSource.Single, key);
            } else {
                overwrite.addOverwrite(itemclass, level, true, key);
            }
            if (args.length >= 4) {
                overwrite.hardness = Float.parseFloat(args[3]);
            }
            overwrite.apply(state);
            ConfigHandler.blockOverwrites.set(key, overwrite);
            ConfigHandler.blockOverwrites.save();
            OverwrittenContent.blocks.put(block.func_149739_a(), overwrite);
            this.sendMessage(sender, "added the block overwrite for '" + TextFormatting.BOLD.toString() + stack.func_82833_r() + TextFormatting.RESET.toString() + "' .");
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String getSynopsis() {
        return this.getName() + " <toolclass> <level> [<hardness>]";
    }
}

