/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.util.ThEUtil;

public class ItemHandlerUtil {
    @Nonnull
    public static ItemStack insert(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.insert(handler, stack, false);
    }

    @Nonnull
    public static ItemStack insertSim(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.insert(handler, stack, true);
    }

    @Nonnull
    public static ItemStack insert(IItemHandler handler, ItemStack stack, boolean simulate) {
        return ItemHandlerUtil.insert(handler, stack, simulate, 0, handler.getSlots());
    }

    @Nonnull
    public static ItemStack extract(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.extract(handler, stack, false);
    }

    @Nonnull
    public static ItemStack extractSim(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.extract(handler, stack, true);
    }

    @Nonnull
    public static ItemStack extract(IItemHandler handler, ItemStack stack, boolean simulate) {
        return ItemHandlerUtil.extract(handler, stack, simulate, 0, handler.getSlots());
    }

    @Nonnull
    public static ItemStack quickMoveSlot(IItemHandler handler, Slot slot) {
        return ItemHandlerUtil.quickMoveSlot(handler, slot, false);
    }

    @Nonnull
    public static ItemStack quickMoveSlotSim(IItemHandler handler, Slot slot) {
        return ItemHandlerUtil.quickMoveSlot(handler, slot, true);
    }

    @Nonnull
    public static ItemStack quickMoveSlot(IItemHandler handler, Slot slot, boolean simulate) {
        return ItemHandlerUtil.quickMoveSlot(handler, slot, simulate, false);
    }

    @Nonnull
    public static ItemStack insert(IItemHandler handler, ItemStack original, boolean simulate, int minValidSlot, int maxValidSlot) {
        if (original == null || original.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = original.func_77946_l();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int slot = minValidSlot; slot < maxValidSlot; ++slot) {
            ItemStack existing = handler.getStackInSlot(slot);
            if (ThEUtil.areItemStacksEqual(existing, copy)) {
                if (!(copy = handler.insertItem(slot, copy, simulate)).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            if (!existing.func_190926_b() || !handler.isItemValid(slot, copy)) continue;
            emptySlots.add(slot);
        }
        Iterator iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            copy = handler.insertItem(slot, copy, simulate);
            if (!copy.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return copy;
    }

    @Nonnull
    public static ItemStack extract(IItemHandler handler, ItemStack original, boolean simulate, int minValidSlot, int maxValidSlot) {
        if (original == null || original.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = null;
        for (int slot = minValidSlot; slot < maxValidSlot; ++slot) {
            if (extracted != null && original.func_190916_E() == extracted.func_190916_E()) {
                return extracted;
            }
            ItemStack inSlot = handler.getStackInSlot(slot);
            if (inSlot.func_190926_b() || !ThEUtil.areItemStacksEqual(original, inSlot)) continue;
            if (extracted == null) {
                extracted = handler.extractItem(slot, original.func_190916_E(), simulate);
                continue;
            }
            ItemStack s = handler.extractItem(slot, original.func_190916_E() - extracted.func_190916_E(), simulate);
            if (s.func_190926_b() || !ThEUtil.areItemStacksEqual(original, s)) continue;
            extracted.func_190917_f(s.func_190916_E());
        }
        return extracted == null || extracted.func_190926_b() ? ItemStack.field_190927_a : extracted;
    }

    @Nonnull
    public static ItemStack quickMoveSlot(IItemHandler handler, Slot slot, boolean simulate, boolean skipArmorSlots) {
        ItemStack left = ItemHandlerUtil.insert(handler, slot.func_75211_c(), simulate, 0, skipArmorSlots ? 36 : handler.getSlots());
        if (!simulate) {
            slot.func_75215_d(left);
        }
        return left;
    }

    @Nonnull
    public static List<ItemStack> getInventoryAsList(IItemHandler handler) {
        if (handler == null) {
            return new ArrayList<ItemStack>();
        }
        return IntStream.range(0, handler.getSlots()).parallel().boxed().map(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(is -> !is.func_190926_b()).collect(Collectors.toList());
    }
}

