/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumicenergistics.ThaumicEnergistics;

public class PacketPlaySound
implements IMessage {
    public ResourceLocation sound;
    public BlockPos pos;
    public SoundCategory category;
    public float vol;
    public float pitch;

    public PacketPlaySound() {
    }

    public PacketPlaySound(BlockPos pos, ResourceLocation sound, SoundCategory category, float vol, float pitch) {
        this.sound = sound;
        this.pos = pos;
        this.category = category;
        this.vol = vol;
        this.pitch = pitch;
    }

    public void fromBytes(ByteBuf buf) {
        this.sound = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.category = SoundCategory.values()[buf.readByte()];
        this.vol = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sound.toString());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte(this.category.ordinal());
        buf.writeFloat(this.vol);
        buf.writeFloat(this.pitch);
    }

    public static class Handler
    implements IMessageHandler<PacketPlaySound, IMessage> {
        public IMessage onMessage(PacketPlaySound message, MessageContext ctx) {
            Minecraft.func_71410_x().field_71441_e.func_184133_a(ThaumicEnergistics.proxy.getPlayerEntFromCtx(ctx), message.pos, new SoundEvent(message.sound), message.category, message.vol, message.pitch);
            return null;
        }
    }
}

