/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumicenergistics.container.ContainerBaseTerminal;
import thaumicenergistics.container.ICraftingContainer;
import thaumicenergistics.container.slot.SlotArcaneResult;
import thaumicenergistics.container.slot.SlotArmor;
import thaumicenergistics.container.slot.SlotGhost;
import thaumicenergistics.container.slot.SlotGhostEssentia;
import thaumicenergistics.container.slot.SlotKnowledgeCore;
import thaumicenergistics.container.slot.SlotME;
import thaumicenergistics.container.slot.SlotUpgrade;
import thaumicenergistics.container.slot.ThESlot;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketInvHeldUpdate;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.util.EssentiaFilter;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;

public abstract class ContainerBase
extends Container {
    public EntityPlayer player;

    public ContainerBase(EntityPlayer player) {
        this.player = player;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slotID, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotID < 0) {
            return super.func_184996_a(slotID, dragType, clickType, player);
        }
        if (slotID >= this.field_75151_b.size()) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.func_75139_a(slotID);
        if (slot instanceof SlotGhostEssentia && ((SlotGhostEssentia)slot).getFilter() != null) {
            EssentiaFilter filter = ((SlotGhostEssentia)slot).getFilter();
            ItemStack stack = player.field_71071_by.func_70445_o().func_77946_l();
            int id = slot.getSlotIndex();
            if (stack.func_77973_b() instanceof IEssentiaContainerItem) {
                IEssentiaContainerItem item = (IEssentiaContainerItem)stack.func_77973_b();
                if (item.getAspects(stack) != null) {
                    AspectList aspects = item.getAspects(stack);
                    filter.setAspect(aspects.getAspects()[0], id);
                }
            } else {
                filter.setAspect(null, id);
            }
            return ItemStack.field_190927_a;
        }
        if (slot instanceof SlotGhost) {
            ItemStack stack = player.field_71071_by.func_70445_o().func_77946_l();
            stack.func_190920_e(1);
            slot.func_75215_d(stack);
            return ItemStack.field_190927_a;
        }
        if (slot instanceof SlotArcaneResult && this instanceof ICraftingContainer) {
            int numToCraft;
            int canCraftNum;
            ICraftingContainer craftingContainer = (ICraftingContainer)((Object)this);
            ItemStack held = player.field_71071_by.func_70445_o();
            if (ForgeUtil.isServer() && (held.func_190926_b() || slot.func_75211_c().func_77969_a(held)) && (clickType == ClickType.QUICK_MOVE || slot.func_75211_c().func_77976_d() - held.func_190916_E() >= slot.func_75211_c().func_190916_E()) && (canCraftNum = craftingContainer.tryCraft(numToCraft = clickType == ClickType.QUICK_MOVE ? Integer.MAX_VALUE : 1)) > 0) {
                ItemStack toCraft = slot.func_75211_c().func_77946_l();
                toCraft.func_190920_e(canCraftNum);
                if (clickType == ClickType.QUICK_MOVE) {
                    int canFitInInvNum = canCraftNum - ForgeUtil.addStackToPlayerInventory(player, toCraft, true).func_190916_E();
                    if (canFitInInvNum < canCraftNum) {
                        toCraft.func_190920_e(canFitInInvNum);
                    }
                    ItemStack newToStore = craftingContainer.onCraft(toCraft);
                    ForgeUtil.addStackToPlayerInventory(player, newToStore, false);
                } else {
                    ItemStack newHeld = craftingContainer.onCraft(toCraft);
                    newHeld.func_190917_f(held.func_190916_E());
                    player.field_71071_by.func_70437_b(newHeld);
                    PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketInvHeldUpdate(newHeld));
                }
            }
            return ItemStack.field_190927_a;
        }
        if (!(this instanceof ContainerBaseTerminal) && clickType == ClickType.QUICK_MOVE) {
            if (slot instanceof SlotUpgrade || slot instanceof SlotKnowledgeCore) {
                ItemHandlerUtil.quickMoveSlot((IItemHandler)new InvWrapper((IInventory)this.player.field_71071_by), slot, false, true);
            } else {
                this.handleQuickMove(slot, slot.func_75211_c());
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotID, dragType, clickType, player);
    }

    protected void handleQuickMove(Slot slot, ItemStack itemStack) {
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    protected void bindPlayerArmour(EntityPlayer player, IItemHandler inv, int offsetX, int offsetY) {
        this.func_75146_a(new SlotArmor(player, inv, 0, offsetX, offsetY + 8 + 54));
        this.func_75146_a(new SlotArmor(player, inv, 1, offsetX, offsetY + 8 + 36));
        this.func_75146_a(new SlotArmor(player, inv, 2, offsetX, offsetY + 8 + 18));
        this.func_75146_a(new SlotArmor(player, inv, 3, offsetX, offsetY + 8));
    }

    protected void bindPlayerInventory(IItemHandler player, int offsetX, int offsetY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new ThESlot(player, 9 * i + j + 9, offsetX + 8 + 18 * j, offsetY + 2 + 18 * i));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new ThESlot(player, i, offsetX + 8 + 18 * i, offsetY + 60));
        }
    }

    public void onAction(EntityPlayerMP player, PacketUIAction packet) {
    }

    public EssentiaFilter getEssentiaFilter() {
        return null;
    }

    public void setEssentiaFilter(EssentiaFilter filter) {
        this.getEssentiaFilter().deserializeNBT(filter.serializeNBT());
    }

    public void handleJEITransfer(EntityPlayer player, NBTTagCompound tag) {
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        if (slotIn instanceof SlotME || slotIn instanceof SlotArcaneResult) {
            return false;
        }
        return super.func_94530_a(stack, slotIn);
    }
}

